/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.SimplePredicate;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLSimplePredicateFactory;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLSimplePredicateFactoryTest {
    private static Map<String, DataType> simplePredicateNameType;
    private static List<SimplePredicate> simplePredicates;
    private static DataDictionary dataDictionary;

    @BeforeClass
    public static void setup() {
        simplePredicateNameType = new HashMap<String, DataType>();
        simplePredicateNameType.put("age", DataType.INTEGER);
        simplePredicateNameType.put("weight", DataType.DOUBLE);
        simplePredicateNameType.put("name", DataType.STRING);
        simplePredicateNameType.put("runner", DataType.BOOLEAN);
        simplePredicates = simplePredicateNameType.entrySet().stream().map(entry -> PMMLModelTestUtils.getSimplePredicate((String)entry.getKey(), PMMLModelTestUtils.getRandomValue((DataType)entry.getValue()), PMMLModelTestUtils.getRandomSimplePredicateOperator())).collect(Collectors.toList());
        ArrayList<DataField> dataFields = new ArrayList<DataField>();
        simplePredicateNameType.forEach((name, dataType) -> {
            DataField toAdd = new DataField();
            toAdd.setName(FieldName.create((String)name));
            toAdd.setDataType(dataType);
            dataFields.add(toAdd);
        });
        dataDictionary = PMMLModelTestUtils.getDataDictionary(dataFields);
    }

    @Test
    public void getSimplePredicateBody() {
        simplePredicates.forEach(simplePredicate -> {
            DataType dataType = simplePredicateNameType.get(simplePredicate.getField().getValue());
            BlockStmt retrieved = KiePMMLSimplePredicateFactory.getSimplePredicateBody((SimplePredicate)simplePredicate, (DataType)dataType);
            this.commonVerifySimplePredicate(retrieved, (SimplePredicate)simplePredicate, dataType);
        });
    }

    private void commonVerifySimplePredicate(BlockStmt toVerify, SimplePredicate source, DataType dataType) {
        OPERATOR kiePMMLOperator = OPERATOR.byName((String)source.getOperator().value());
        Object value = KiePMMLPredicateFactory.getActualValue((Object)source.getValue(), (DataType)dataType);
        if (kiePMMLOperator.isValueOperator() && value == null) {
            BlockStmt expected = JavaParserUtils.parseBlock((String)"{    return false;}");
            JavaParserUtils.equalsNode((Node)expected, (Node)toVerify);
        } else if (kiePMMLOperator.isOnlyNumberOperator() && value != null && !(value instanceof Number)) {
            BlockStmt expected = JavaParserUtils.parseBlock((String)"{    return false;}");
            JavaParserUtils.equalsNode((Node)expected, (Node)toVerify);
        } else {
            String expectedString = source.getField().getValue();
            Assert.assertTrue((boolean)toVerify.toString().contains(expectedString));
            Assert.assertFalse((boolean)toVerify.toString().contains("avalue"));
        }
    }
}

