/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.Array;
import org.dmg.pmml.SimpleSetPredicate;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.ARRAY_TYPE;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLSimpleSetPredicateFactory;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;

public class KiePMMLSimpleSetPredicateFactoryTest {
    private static Map<String, Array.Type> simpleSetPredicateNameType;
    private static List<SimpleSetPredicate> simpleSetPredicates;

    @BeforeClass
    public static void setup() {
        simpleSetPredicateNameType = new HashMap<String, Array.Type>();
        simpleSetPredicateNameType.put("age", Array.Type.INT);
        simpleSetPredicateNameType.put("weight", Array.Type.REAL);
        simpleSetPredicateNameType.put("name", Array.Type.STRING);
        simpleSetPredicates = simpleSetPredicateNameType.entrySet().stream().map(entry -> {
            List<String> values = PMMLModelTestUtils.getStringObjects((Array.Type)entry.getValue(), 4);
            return PMMLModelTestUtils.getSimpleSetPredicate((String)entry.getKey(), (Array.Type)entry.getValue(), values, PMMLModelTestUtils.getRandomSimpleSetPredicateOperator());
        }).collect(Collectors.toList());
    }

    @Test
    public void getSimpleSetPredicateBody() {
        simpleSetPredicates.forEach(simpleSetPredicate -> {
            BlockStmt retrieved = KiePMMLSimpleSetPredicateFactory.getSimpleSetPredicateBody((SimpleSetPredicate)simpleSetPredicate);
            this.commonVerifySimpleSetPredicate(retrieved, (SimpleSetPredicate)simpleSetPredicate);
        });
    }

    private void commonVerifySimpleSetPredicate(BlockStmt toVerify, SimpleSetPredicate source) {
        String expected = "";
        if (source.getBooleanOperator().equals((Object)SimpleSetPredicate.BooleanOperator.IS_IN)) {
            expected = "return values.contains(value);";
        } else if (source.getBooleanOperator().equals((Object)SimpleSetPredicate.BooleanOperator.IS_NOT_IN)) {
            expected = "return !values.contains(value);";
        } else {
            Assert.fail((String)("Unexpected BooleanOperator " + source.getBooleanOperator()));
        }
        String blockString = toVerify.toString();
        Assert.assertTrue((boolean)blockString.contains(expected));
        List values = KiePMMLPredicateFactory.getObjectsFromArray((Array)source.getArray());
        ARRAY_TYPE arrayType = ARRAY_TYPE.byName((String)source.getArray().getType().value());
        String expectedValues = values.stream().map(value -> {
            if (arrayType.equals((Object)ARRAY_TYPE.STRING)) {
                return String.format("\"%s\"", value.toString());
            }
            return value.toString();
        }).collect(Collectors.joining(", "));
        expected = String.format("List values = java.util.Arrays.asList(%s);", expectedValues);
        Assert.assertTrue((boolean)blockString.contains(expected));
        expected = source.getField().getValue();
        Assert.assertTrue((boolean)blockString.contains(expected));
        Assert.assertFalse((boolean)blockString.contains("avalue"));
    }
}

