/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.DefineFunctionUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtilsTest;

public class DefineFunctionUtilsTest {
    private static final Function<Supplier<Expression>, DefineFunction> defineFunctionCreator = supplier -> {
        Expression expression = (Expression)supplier.get();
        DefineFunction defineFunction = new DefineFunction();
        defineFunction.setName("DEFINE_FUNCTION_" + expression.getClass().getSimpleName());
        defineFunction.setExpression(expression);
        return defineFunction;
    };

    @Test(expected=KiePMMLException.class)
    public void getDefineFunctionsMethodMapUnsupportedExpression() {
        List defineFunctions = ExpressionFunctionUtilsTest.unsupportedExpressionSupplier.stream().map(defineFunctionCreator).collect(Collectors.toList());
        DefineFunctionUtils.getDefineFunctionsMethodMap(defineFunctions);
    }

    @Test
    public void getDefineFunctionsMethodMapSupportedExpression() {
        List defineFunctions = ExpressionFunctionUtilsTest.supportedExpressionSupplier.stream().map(defineFunctionCreator).collect(Collectors.toList());
        Map retrieved = DefineFunctionUtils.getDefineFunctionsMethodMap(defineFunctions);
        Assert.assertEquals((long)defineFunctions.size(), (long)retrieved.size());
    }

    @Test
    public void getDefineFunctionMethodDeclarationUnsupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.unsupportedExpressionSupplier) {
            DefineFunction defineFunction = defineFunctionCreator.apply(supplier);
            try {
                DefineFunctionUtils.getDefineFunctionMethodDeclaration((DefineFunction)defineFunction);
                Assert.fail((String)String.format("Expecting KiePMMLException for %s", defineFunction));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        }
    }

    @Test
    public void getDefineFunctionMethodDeclarationSupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.supportedExpressionSupplier) {
            DefineFunction defineFunction = defineFunctionCreator.apply(supplier);
            try {
                DefineFunctionUtils.getDefineFunctionMethodDeclaration((DefineFunction)defineFunction);
            }
            catch (Exception e) {
                Assert.fail((String)String.format("Unexpected %s for %s", e, defineFunction.getExpression().getClass()));
            }
        }
    }

    @Test(expected=KiePMMLException.class)
    public void getDefineFunctionMethodDeclarationWithoutExpression() {
        DefineFunctionUtils.getDefineFunctionMethodDeclaration((DefineFunction)new DefineFunction());
    }
}

