/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.DerivedFieldFunctionUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtilsTest;

public class DerivedFieldFunctionUtilsTest {
    private static final Function<Supplier<Expression>, DerivedField> derivedFieldCreator = supplier -> {
        Expression expression = (Expression)supplier.get();
        DerivedField defineFunction = new DerivedField();
        defineFunction.setName(FieldName.create((String)("DERIVED_FIELD_" + expression.getClass().getSimpleName())));
        defineFunction.setExpression(expression);
        return defineFunction;
    };

    @Test(expected=KiePMMLException.class)
    public void getDerivedFieldsMethodMapUnsupportedExpression() {
        List derivedFields = ExpressionFunctionUtilsTest.unsupportedExpressionSupplier.stream().map(derivedFieldCreator).collect(Collectors.toList());
        AtomicInteger arityCounter = new AtomicInteger();
        DerivedFieldFunctionUtils.getDerivedFieldsMethodMap(derivedFields, (AtomicInteger)arityCounter);
    }

    @Test
    public void getDerivedFieldsMethodMapSupportedExpression() {
        List derivedFields = ExpressionFunctionUtilsTest.supportedExpressionSupplier.stream().map(derivedFieldCreator).collect(Collectors.toList());
        AtomicInteger arityCounter = new AtomicInteger();
        Map retrieved = DerivedFieldFunctionUtils.getDerivedFieldsMethodMap(derivedFields, (AtomicInteger)arityCounter);
        Assert.assertEquals((long)derivedFields.size(), (long)retrieved.size());
    }

    @Test
    public void getDerivedFieldMethodDeclarationUnsupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.unsupportedExpressionSupplier) {
            DerivedField derivedField = derivedFieldCreator.apply(supplier);
            try {
                DerivedFieldFunctionUtils.getDerivedFieldMethodDeclaration((DerivedField)derivedField, (AtomicInteger)new AtomicInteger());
                Assert.fail((String)String.format("Expecting KiePMMLException for %s", derivedField));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        }
    }

    @Test
    public void getDerivedFieldMethodDeclarationSupportedExpression() {
        for (Supplier<Expression> supplier : ExpressionFunctionUtilsTest.supportedExpressionSupplier) {
            DerivedField derivedField = derivedFieldCreator.apply(supplier);
            try {
                DerivedFieldFunctionUtils.getDerivedFieldMethodDeclaration((DerivedField)derivedField, (AtomicInteger)new AtomicInteger());
            }
            catch (Exception e) {
                Assert.fail((String)String.format("Unexpected %s for %s", e, derivedField.getExpression().getClass()));
            }
        }
    }

    @Test(expected=KiePMMLException.class)
    public void getDerivedFieldMethodDeclarationWithoutExpression() {
        DerivedFieldFunctionUtils.getDerivedFieldMethodDeclaration((DerivedField)new DerivedField(), (AtomicInteger)new AtomicInteger());
    }
}

