/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.TextIndex;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.utils.ConverterTypeUtil;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;

public class ExpressionFunctionUtilsTest {
    static final List<Supplier<Expression>> supportedExpressionSupplier;
    static final List<Supplier<Expression>> unsupportedExpressionSupplier;
    static final Supplier<Constant> constantSupplier;
    static final Supplier<FieldRef> fieldRefSupplier;
    static final Supplier<Apply> applySupplier;
    static final ClassOrInterfaceType OBJECT_CLASS;
    static final ClassOrInterfaceType DOUBLE_CLASS;
    static final ClassOrInterfaceType STRING_CLASS;

    @Test
    public void getKiePMMLNameValueExpressionMethodDeclarationUnsupportedExpression() {
        AtomicInteger arityCounter = new AtomicInteger();
        unsupportedExpressionSupplier.forEach(supplier -> {
            Expression expression = (Expression)supplier.get();
            String methodName = String.format("%s%s", expression.getClass().getSimpleName(), arityCounter);
            try {
                ExpressionFunctionUtils.getExpressionMethodDeclarationWithKiePMMLNameValues((Expression)expression, (DataType)DataType.STRING, (String)methodName);
                Assert.fail((String)("Expecting KiePMMLException for " + expression));
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof KiePMMLException));
            }
        });
    }

    @Test
    public void getKiePMMLNameValueExpressionMethodDeclarationSupportedExpression() {
        AtomicInteger arityCounter = new AtomicInteger();
        supportedExpressionSupplier.forEach(supplier -> {
            Expression expression = (Expression)supplier.get();
            String methodName = String.format("%s%s", expression.getClass().getSimpleName(), arityCounter);
            Assert.assertNotNull((Object)ExpressionFunctionUtils.getExpressionMethodDeclarationWithKiePMMLNameValues((Expression)expression, (DataType)DataType.STRING, (String)methodName));
        });
    }

    @Test
    public void getVariableParametersExpressionMethodUnsupportedDeclaration() {
        AtomicInteger arityCounter = new AtomicInteger();
        LinkedList<ParameterField> parameterFields = new LinkedList<ParameterField>();
        ParameterField toAdd = new ParameterField();
        toAdd.setDataType(DataType.DOUBLE);
        toAdd.setName(FieldName.create((String)"otherParameter"));
        parameterFields.add(toAdd);
        unsupportedExpressionSupplier.forEach(supplier -> {
            Expression expression = (Expression)supplier.get();
            String methodName = String.format("%s%s", expression.getClass().getSimpleName(), arityCounter);
            try {
                ExpressionFunctionUtils.getExpressionMethodDeclarationWithVariableParameters((String)methodName, (Expression)expression, (DataType)DataType.STRING, (List)parameterFields);
                Assert.fail((String)("Expecting KiePMMLException for " + expression));
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof KiePMMLException));
            }
        });
    }

    @Test
    public void getVariableParametersExpressionMethodSupportedDeclaration() {
        AtomicInteger arityCounter = new AtomicInteger();
        LinkedList<ParameterField> parameterFields = new LinkedList<ParameterField>();
        ParameterField toAdd = new ParameterField();
        toAdd.setDataType(DataType.DOUBLE);
        toAdd.setName(FieldName.create((String)"otherParameter"));
        parameterFields.add(toAdd);
        supportedExpressionSupplier.forEach(supplier -> {
            Expression expression = (Expression)supplier.get();
            String methodName = String.format("%s%s", expression.getClass().getSimpleName(), arityCounter);
            Assert.assertNotNull((Object)ExpressionFunctionUtils.getExpressionMethodDeclarationWithVariableParameters((String)methodName, (Expression)expression, (DataType)DataType.STRING, (List)parameterFields));
        });
    }

    @Test
    public void getApplyExpressionMethodDeclaration() {
        Apply apply = applySupplier.get();
        int methodArity = new Random().nextInt(20);
        String methodName = String.format("%s%s", apply.getClass().getSimpleName(), methodArity);
        MethodDeclaration retrieved = ExpressionFunctionUtils.getApplyExpressionMethodDeclarationWithKiePMMLValues((String)methodName, (Apply)apply, (ClassOrInterfaceType)OBJECT_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)String.format("java.lang.Object %s(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1) {    java.lang.Object variableapplyVariableConstant1 = 34.6;    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();    java.lang.Object variableapplyVariableFieldRef2 = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(null);    java.lang.Object applyVariable = this.FUNCTION_NAME(param1, variableapplyVariableConstant1, variableapplyVariableFieldRef2);    return applyVariable;}", methodName));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
        ParameterField parameterField = new ParameterField(FieldName.create((String)"FIELD_REF"));
        LinkedHashMap<String, ClassOrInterfaceType> modifiedParametersMap = new LinkedHashMap<String, ClassOrInterfaceType>(ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        modifiedParametersMap.put(parameterField.getName().toString(), StaticJavaParser.parseClassOrInterfaceType((String)ModelUtils.getBoxedClassName((ParameterField)parameterField)));
        retrieved = ExpressionFunctionUtils.getApplyExpressionMethodDeclarationWithKiePMMLValues((String)methodName, (Apply)apply, (ClassOrInterfaceType)OBJECT_CLASS, modifiedParametersMap);
        expected = JavaParserUtils.parseMethod((String)String.format("java.lang.Object %s(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1, java.lang.Object FIELD_REF) {    java.lang.Object variableapplyVariableConstant1 = 34.6;    java.lang.Object variableapplyVariableFieldRef2 = FIELD_REF != null ? (java.lang.Object) org.kie.pmml.api.utils.ConverterTypeUtil.convert(java.lang.Object.class, FIELD_REF) : (java.lang.Object) null;    java.lang.Object applyVariable = this.FUNCTION_NAME(param1, variableapplyVariableConstant1, variableapplyVariableFieldRef2);    return applyVariable;}", methodName));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
    }

    @Test
    public void getConstantExpressionMethodDeclaration() {
        Constant constant = constantSupplier.get();
        int methodArity = new Random().nextInt(20);
        String methodName = String.format("%s%s", constant.getClass().getSimpleName(), methodArity);
        MethodDeclaration retrieved = ExpressionFunctionUtils.getConstantExpressionMethodDeclaration((String)methodName, (Constant)constant, (ClassOrInterfaceType)DOUBLE_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expectedVariableDeclaration = String.format("%s %s = %s;", Double.class.getName(), "constantValue", constant.getValue());
        this.commonValidateConstant(retrieved, constant, methodName, Double.class.getName(), expectedVariableDeclaration);
        constant = new Constant();
        constant.setDataType(DataType.STRING);
        constant.setValue((Object)"EXPECTED");
        methodArity = new Random().nextInt(20);
        methodName = String.format("%s%s", constant.getClass().getSimpleName(), methodArity);
        retrieved = ExpressionFunctionUtils.getConstantExpressionMethodDeclaration((String)methodName, (Constant)constant, (ClassOrInterfaceType)STRING_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        expectedVariableDeclaration = String.format("%s %s = \"%s\";", String.class.getName(), "constantValue", constant.getValue());
        this.commonValidateConstant(retrieved, constant, methodName, String.class.getName(), expectedVariableDeclaration);
    }

    @Test
    public void getFieldRefExpressionMethodDeclaration() {
        int methodArity = new Random().nextInt(20);
        FieldRef fieldRef = fieldRefSupplier.get();
        String methodName = String.format("%s%s", fieldRef.getClass().getSimpleName(), methodArity);
        MethodDeclaration retrieved = ExpressionFunctionUtils.getFieldRefExpressionMethodDeclarationWithKiePMMLValues((String)methodName, (FieldRef)fieldRef, (ClassOrInterfaceType)STRING_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        String expected = String.format("java.lang.String fieldRefVariable = (java.lang.String) kiePMMLNameValue.map(%1$s::getValue).orElse(%2$s);", KiePMMLNameValue.class.getName(), fieldRef.getMapMissingTo());
        this.commonValidateFieldRefMethod(retrieved, methodName, expected, String.class.getName());
        fieldRef.setMapMissingTo("MAP_MISSING_TO");
        methodName = String.format("%s%s", fieldRef.getClass().getSimpleName(), methodArity);
        retrieved = ExpressionFunctionUtils.getFieldRefExpressionMethodDeclarationWithKiePMMLValues((String)methodName, (FieldRef)fieldRef, (ClassOrInterfaceType)STRING_CLASS, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        expected = String.format("java.lang.String fieldRefVariable = (java.lang.String) kiePMMLNameValue.map(%1$s::getValue).orElse(\"%2$s\");", KiePMMLNameValue.class.getName(), fieldRef.getMapMissingTo());
        this.commonValidateFieldRefMethod(retrieved, methodName, expected, String.class.getName());
    }

    @Test
    public void getUnsupportedExpressionBlockStmt() {
        AtomicInteger arityCounter = new AtomicInteger();
        ClassOrInterfaceType returnedType = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        unsupportedExpressionSupplier.forEach(supplier -> {
            Expression expression = (Expression)supplier.get();
            String methodName = String.format("%s%s", expression.getClass().getSimpleName(), arityCounter);
            try {
                ExpressionFunctionUtils.getExpressionBlockStmtWithKiePMMLValues((String)methodName, (Expression)expression, (ClassOrInterfaceType)returnedType, new LinkedHashMap());
                Assert.fail((String)("Expecting KiePMMLException for " + expression));
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof KiePMMLException));
            }
        });
    }

    @Test
    public void getSupportedExpressionBlockStmt() {
        AtomicInteger arityCounter = new AtomicInteger();
        ClassOrInterfaceType returnedType = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        supportedExpressionSupplier.forEach(supplier -> {
            Expression expression = (Expression)supplier.get();
            String methodName = String.format("%s%s", expression.getClass().getSimpleName(), arityCounter);
            Assert.assertNotNull((Object)ExpressionFunctionUtils.getExpressionBlockStmtWithKiePMMLValues((String)methodName, (Expression)expression, (ClassOrInterfaceType)returnedType, new LinkedHashMap()));
        });
    }

    @Test
    public void getApplyExpressionBlockStmt() {
        Apply apply = applySupplier.get();
        String variableName = "VARIABLE_NAME";
        BlockStmt retrieved = ExpressionFunctionUtils.getApplyExpressionBlockStmtWithKiePMMLValues((String)variableName, (Apply)apply, (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{    java.lang.Object variable%1$sConstant1 = 34.6;    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();    java.lang.Object variable%1$sFieldRef2 = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(null);    java.lang.Object %1$s = this.FUNCTION_NAME(param1, variable%1$sConstant1, variable%1$sFieldRef2);}", variableName));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
    }

    @Test
    public void getApplyExpressionNestedBlockStmt() {
        Apply nestedApply = applySupplier.get();
        Constant constant = new Constant();
        constant.setDataType(DataType.STRING);
        constant.setValue((Object)"STRING_VALUE");
        String functionName = "EXTERNAL_FUNCTION_NAME";
        Apply apply = new Apply();
        apply.addExpressions(new Expression[]{constant, nestedApply});
        apply.setFunction(functionName);
        String variableName = "VARIABLE_NAME";
        BlockStmt retrieved = ExpressionFunctionUtils.getApplyExpressionBlockStmtWithKiePMMLValues((String)variableName, (Apply)apply, (ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName()), (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{    java.lang.Object variable%1$sConstant1 = \"STRING_VALUE\";    java.lang.Object variablevariable%1$sApply2Constant1 = 34.6;    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();    java.lang.Object variablevariable%1$sApply2FieldRef2 = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(null);    java.lang.Object variable%1$sApply2 = this.FUNCTION_NAME(param1, variablevariableVARIABLE_NAMEApply2Constant1, variablevariable%1$sApply2FieldRef2);    java.lang.Object %1$s = this.EXTERNAL_FUNCTION_NAME(param1, variable%1$sConstant1, variable%1$sApply2);}", variableName));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
    }

    @Test
    public void getConstantExpressionBlockStmt() {
        String variableName = "VARIABLE_NAME";
        Constant constant = constantSupplier.get();
        ClassOrInterfaceType returnedType = StaticJavaParser.parseClassOrInterfaceType((String)Double.class.getName());
        BlockStmt retrieved = ExpressionFunctionUtils.getConstantExpressionBlockStmt((String)variableName, (Constant)constant, (ClassOrInterfaceType)returnedType);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{    %1$s %2$s = %3$s;}", Double.class.getName(), variableName, constant.getValue()));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
        constant.setDataType(DataType.STRING);
        constant.setValue((Object)"STRING_VALUE");
        returnedType = StaticJavaParser.parseClassOrInterfaceType((String)String.class.getName());
        retrieved = ExpressionFunctionUtils.getConstantExpressionBlockStmt((String)variableName, (Constant)constant, (ClassOrInterfaceType)returnedType);
        expected = JavaParserUtils.parseBlock((String)String.format("{    %1$s %2$s = \"%3$s\";}", String.class.getName(), variableName, constant.getValue()));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
    }

    @Test
    public void getFieldRefExpressionFromKiePMMLNameValuesBlockStmt() {
        String variableName = "VARIABLE_NAME";
        FieldRef fieldRef = fieldRefSupplier.get();
        String classType = Object.class.getName();
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)classType);
        BlockStmt retrieved = ExpressionFunctionUtils.getFieldRefExpressionBlockStmtWithKiePMMLValues((String)variableName, (FieldRef)fieldRef, (ClassOrInterfaceType)classOrInterfaceType);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();    %1$s %2$s = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(null);}", classType, variableName));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
        String mapMissingTo = "MAP_MISSING_TO";
        fieldRef.setMapMissingTo(mapMissingTo);
        retrieved = ExpressionFunctionUtils.getFieldRefExpressionBlockStmtWithKiePMMLValues((String)variableName, (FieldRef)fieldRef, (ClassOrInterfaceType)classOrInterfaceType);
        String mapMissingQuoted = String.format("\"%s\"", mapMissingTo);
        expected = JavaParserUtils.parseBlock((String)String.format("{    java.util.Optional<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> kiePMMLNameValue = param1.stream().filter((lmbdParam) -> java.util.Objects.equals(\"FIELD_REF\", lmbdParam.getName())).findFirst();    %1$s %2$s = (java.lang.Object) kiePMMLNameValue.map(org.kie.pmml.commons.model.tuples.KiePMMLNameValue::getValue).orElse(%3$s);}", classType, variableName, mapMissingQuoted));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
    }

    @Test
    public void getFieldRefExpressionFromInputValueBlockStmt() {
        String variableName = "VARIABLE_NAME";
        FieldRef fieldRef = fieldRefSupplier.get();
        String classType = Object.class.getName();
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)classType);
        BlockStmt retrieved = ExpressionFunctionUtils.getFieldRefExpressionBlockStmtWithInputValue((String)variableName, (FieldRef)fieldRef, (ClassOrInterfaceType)classOrInterfaceType);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{    %1$s %2$s = FIELD_REF != null ? (%1$s) org.kie.pmml.api.utils.ConverterTypeUtil.convert(%1$s.class, FIELD_REF) : (%1$s) null;}", classType, variableName));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
        String mapMissingTo = "MAP_MISSING_TO";
        fieldRef.setMapMissingTo(mapMissingTo);
        retrieved = ExpressionFunctionUtils.getFieldRefExpressionBlockStmtWithInputValue((String)variableName, (FieldRef)fieldRef, (ClassOrInterfaceType)classOrInterfaceType);
        String mapMissingQuoted = String.format("\"%s\"", mapMissingTo);
        expected = JavaParserUtils.parseBlock((String)String.format("{    %1$s %2$s = FIELD_REF != null ? (%1$s) org.kie.pmml.api.utils.ConverterTypeUtil.convert(%1$s.class, FIELD_REF) : (%1$s) %3$s;}", classType, variableName, mapMissingQuoted));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
    }

    @Test
    public void getExpressionMethodDeclaration() {
        String methodName = "METHOD_NAME";
        String variableName = "VARIABLE_NAME";
        String classType = Object.class.getName();
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)classType);
        MethodDeclaration retrieved = ExpressionFunctionUtils.getExpressionMethodDeclarationWithKiePMMLValues((String)methodName, (String)variableName, (BlockStmt)new BlockStmt(), (ClassOrInterfaceType)classOrInterfaceType, (LinkedHashMap)ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        Assert.assertNotNull((Object)retrieved);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)String.format("%1$s %2$s(java.util.List<org.kie.pmml.commons.model.tuples.KiePMMLNameValue> param1) {    return %3$s;}", classType, methodName, variableName));
        JavaParserUtils.equalsNode((Node)expected, (Node)retrieved);
    }

    @Test
    public void converterTypeUtilFieldAccessorExpr() {
        Assert.assertEquals((Object)ConverterTypeUtil.class.getName(), (Object)ExpressionFunctionUtils.CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR.toString());
    }

    @Test
    public void getClassOrInterfaceTypes() {
        List<ParameterField> parameterFields = PMMLModelTestUtils.getParameterFields();
        LinkedHashMap retrieved = ExpressionFunctionUtils.getNameClassOrInterfaceTypeMap(parameterFields);
        Assert.assertEquals((long)parameterFields.size(), (long)retrieved.size());
        for (ParameterField parameter : parameterFields) {
            Assert.assertTrue((boolean)retrieved.containsKey(parameter.getName().toString()));
            this.commonVerifyParameterClassOrInterfaceType((ClassOrInterfaceType)retrieved.get(parameter.getName().toString()), parameter);
        }
    }

    private void commonVerifyParameterClassOrInterfaceType(ClassOrInterfaceType toVerify, ParameterField parameterField) {
        String expectedClass = ModelUtils.getBoxedClassName((ParameterField)parameterField);
        Assert.assertEquals((Object)expectedClass, (Object)toVerify.toString());
    }

    private void commonValidateConstant(MethodDeclaration retrieved, Constant constant, String expectedMethodName, String expectedClass, String variableDeclaration) {
        this.commonValidateMethodDeclaration(retrieved, expectedMethodName);
        Assert.assertEquals((Object)expectedClass, (Object)retrieved.getType().asString());
        BlockStmt body = (BlockStmt)retrieved.getBody().orElseThrow(() -> new RuntimeException("Expecting BlockBody"));
        NodeList statements = body.getStatements();
        Assert.assertEquals((long)2L, (long)statements.size());
        Assert.assertTrue((boolean)(statements.get(0) instanceof ExpressionStmt));
        Assert.assertEquals((Object)variableDeclaration, (Object)((Statement)statements.get(0)).toString());
        Assert.assertTrue((boolean)(statements.get(1) instanceof ReturnStmt));
        ReturnStmt returnStmt = (ReturnStmt)statements.get(1);
        String retrievedString = returnStmt.toString();
        String expected = String.format("return %s;", "constantValue");
        Assert.assertEquals((Object)expected, (Object)retrievedString);
        CodegenTestUtils.commonValidateCompilation(retrieved);
    }

    private void commonValidateFieldRefMethod(MethodDeclaration retrieved, String expectedMethodName, String expectedVariableAssignment, String expectedType) {
        this.commonValidateMethodDeclaration(retrieved, expectedMethodName);
        Assert.assertEquals((Object)expectedType, (Object)retrieved.getType().asString());
        BlockStmt body = (BlockStmt)retrieved.getBody().orElseThrow(() -> new RuntimeException("Expecting BlockBody"));
        NodeList statements = body.getStatements();
        Assert.assertEquals((long)3L, (long)statements.size());
        Assert.assertTrue((boolean)(statements.get(1) instanceof ExpressionStmt));
        Assert.assertEquals((Object)expectedVariableAssignment, (Object)((Statement)statements.get(1)).toString());
        Assert.assertTrue((boolean)(statements.get(2) instanceof ReturnStmt));
        ReturnStmt returnStmt = (ReturnStmt)statements.get(2);
        String retrievedString = returnStmt.toString();
        Assert.assertEquals((Object)"return fieldRefVariable;", (Object)retrievedString);
        CodegenTestUtils.commonValidateCompilation(retrieved);
    }

    private void commonValidateMethodDeclaration(MethodDeclaration toValidate, String expectedMethodName) {
        Assert.assertNotNull((Object)toValidate);
        Assert.assertEquals((Object)toValidate.getName().asString(), (Object)expectedMethodName);
    }

    static {
        constantSupplier = () -> {
            Constant toReturn = new Constant();
            toReturn.setDataType(DataType.DOUBLE);
            toReturn.setValue((Object)34.6);
            return toReturn;
        };
        fieldRefSupplier = () -> new FieldRef(FieldName.create((String)"FIELD_REF"));
        applySupplier = () -> {
            Constant constant = constantSupplier.get();
            FieldRef fieldRef = fieldRefSupplier.get();
            String functionName = "FUNCTION_NAME";
            Apply toReturn = new Apply();
            toReturn.addExpressions(new Expression[]{constant, fieldRef});
            toReturn.setFunction(functionName);
            return toReturn;
        };
        OBJECT_CLASS = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        DOUBLE_CLASS = StaticJavaParser.parseClassOrInterfaceType((String)Double.class.getName());
        STRING_CLASS = StaticJavaParser.parseClassOrInterfaceType((String)String.class.getName());
        supportedExpressionSupplier = new ArrayList<Supplier<Expression>>();
        supportedExpressionSupplier.add(applySupplier::get);
        supportedExpressionSupplier.add(constantSupplier::get);
        supportedExpressionSupplier.add(fieldRefSupplier::get);
        unsupportedExpressionSupplier = new ArrayList<Supplier<Expression>>();
        unsupportedExpressionSupplier.add(Aggregate::new);
        unsupportedExpressionSupplier.add(Discretize::new);
        unsupportedExpressionSupplier.add(Lag::new);
        unsupportedExpressionSupplier.add(MapValues::new);
        unsupportedExpressionSupplier.add(NormContinuous::new);
        unsupportedExpressionSupplier.add(NormDiscrete::new);
        unsupportedExpressionSupplier.add(TextIndex::new);
    }
}

