/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameOpType;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLLoadedModelUtilsTest {
    private static final String NO_TARGET_SOURCE = "NoTargetFieldSample.pmml";
    private static final String ONE_MINING_TARGET_SOURCE = "OneMiningTargetFieldSample.pmml";
    private static final String MULTIPLE_TARGETS_SOURCE = "MultipleTargetsFieldSample.pmml";
    private static final String NO_MODELNAME_SAMPLE_NAME = "NoModelNameSample";
    private static final String NO_MODELNAME_SAMPLE = "NoModelNameSample.pmml";
    private static final String WHAT_I_DO_TARGET_FIELD = "whatIdo";
    private static final String CAR_LOCATION_FIELD = "car_location";
    private static final String NUMBER_OF_CLAIMS_FIELD = "number_of_claims";
    private static final String SALARY_FIELD = "salary";
    private static final String OUTLOOK_FIELD = "outlook";
    private static final String TEMPERATURE_FIELD = "temperature";
    private static final String NOT_EXISTING_FIELD = "not_existing";
    private PMML pmmlModel;

    @Test
    public void getTargetFieldNoTarget() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)NO_TARGET_SOURCE), (String)NO_TARGET_SOURCE);
        Assert.assertTrue((boolean)ModelUtils.getTargetFieldName((DataDictionary)this.pmmlModel.getDataDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0))).isPresent());
        Assert.assertFalse((boolean)ModelUtils.getTargetFields((DataDictionary)this.pmmlModel.getDataDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0))).isEmpty());
    }

    @Test
    public void getTargetFieldOneMiningTarget() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        Optional retrieved = ModelUtils.getTargetFieldName((DataDictionary)this.pmmlModel.getDataDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)));
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)WHAT_I_DO_TARGET_FIELD, retrieved.get());
        List retrieveds = ModelUtils.getTargetFields((DataDictionary)this.pmmlModel.getDataDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)));
        Assert.assertEquals((long)1L, (long)retrieveds.size());
        Assert.assertEquals((Object)WHAT_I_DO_TARGET_FIELD, (Object)((KiePMMLNameOpType)retrieveds.get(0)).getName());
    }

    @Test
    public void getTargetFieldMultipleTargets() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)MULTIPLE_TARGETS_SOURCE), (String)MULTIPLE_TARGETS_SOURCE);
        Optional retrieved = ModelUtils.getTargetFieldName((DataDictionary)this.pmmlModel.getDataDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)));
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)CAR_LOCATION_FIELD, retrieved.get());
        List retrieveds = ModelUtils.getTargetFields((DataDictionary)this.pmmlModel.getDataDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)));
        Assert.assertEquals((long)1L, (long)retrieveds.size());
        Assert.assertEquals((Object)CAR_LOCATION_FIELD, (Object)((KiePMMLNameOpType)retrieveds.get(0)).getName());
    }

    @Test
    public void getOpTypeFromDataFieldExisting() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)NO_TARGET_SOURCE), (String)NO_TARGET_SOURCE);
        OP_TYPE retrieved = ModelUtils.getOpType((DataDictionary)this.pmmlModel.getDataDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), (String)TEMPERATURE_FIELD);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)OP_TYPE.CONTINUOUS, (Object)retrieved);
    }

    @Test
    public void getOpTypeFromMiningFieldExisting() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        OP_TYPE retrieved = ModelUtils.getOpType((DataDictionary)this.pmmlModel.getDataDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), (String)OUTLOOK_FIELD);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)OP_TYPE.CATEGORICAL, (Object)retrieved);
    }

    @Test(expected=KiePMMLInternalException.class)
    public void getOpTypeNotExistingField() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        ModelUtils.getOpType((DataDictionary)this.pmmlModel.getDataDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), (String)NOT_EXISTING_FIELD);
    }

    @Test
    public void populateMissingModelNames() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)NO_MODELNAME_SAMPLE), (String)NO_MODELNAME_SAMPLE);
        List models = this.pmmlModel.getModels();
        for (int i = 0; i < models.size(); ++i) {
            Model model = (Model)models.get(i);
            Assert.assertNotNull((Object)model.getModelName());
            Assert.assertFalse((boolean)model.getModelName().isEmpty());
            String expected = String.format("%s%s%s", NO_MODELNAME_SAMPLE_NAME, model.getClass().getSimpleName(), i);
            Assert.assertEquals((Object)expected, (Object)model.getModelName());
        }
    }
}

