/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.DerivedFieldFunctionUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLModelFactoryUtilsTest {
    private static final String SOURCE = "TransformationsSample.pmml";
    private static final String TEMPLATE_SOURCE = "Template.tmpl";
    private static final String TEMPLATE_CLASS_NAME = "Template";
    private static PMML pmmlModel;
    private static TreeModel model;
    private ConstructorDeclaration constructorDeclaration;
    private ExplicitConstructorInvocationStmt superInvocation;
    private ClassOrInterfaceDeclaration classOrInterfaceDeclaration;

    @BeforeClass
    public static void setup() throws Exception {
        pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)SOURCE), (String)"");
        Assert.assertNotNull((Object)pmmlModel);
        model = (TreeModel)pmmlModel.getModels().get(0);
        Assert.assertNotNull((Object)model);
    }

    @Before
    public void init() {
        CompilationUnit compilationUnit = JavaParserUtils.getFromFileName((String)TEMPLATE_SOURCE);
        this.constructorDeclaration = (ConstructorDeclaration)((ClassOrInterfaceDeclaration)compilationUnit.getClassByName(TEMPLATE_CLASS_NAME).orElseThrow(() -> new RuntimeException("Failed to retrieve ClassOrInterfaceDeclaration Template  from Template.tmpl"))).getDefaultConstructor().orElseThrow(() -> new RuntimeException("Failed to retrieve default constructor from Template.tmpl"));
        Assert.assertNotNull((Object)this.constructorDeclaration);
        Assert.assertNotNull((Object)this.constructorDeclaration.getBody());
        Optional optSuperInvocation = CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)this.constructorDeclaration.getBody());
        Assert.assertTrue((boolean)optSuperInvocation.isPresent());
        this.superInvocation = (ExplicitConstructorInvocationStmt)optSuperInvocation.get();
        Assert.assertEquals((Object)TEMPLATE_CLASS_NAME, (Object)this.constructorDeclaration.getName().asString());
        Assert.assertEquals((Object)"super(name, Collections.emptyList(), operator, second);", (Object)this.superInvocation.toString());
        Assert.assertTrue((boolean)compilationUnit.getClassByName(TEMPLATE_CLASS_NAME).isPresent());
        this.classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)compilationUnit.getClassByName(TEMPLATE_CLASS_NAME).get();
    }

    @Test
    public void setConstructorSuperNameInvocation() {
        String generatedClassName = "generatedClassName";
        String name = "newName";
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)generatedClassName, (ConstructorDeclaration)this.constructorDeclaration, (String)name);
        this.commonVerifySuperInvocation(generatedClassName, name);
    }

    @Test
    public void setKiePMMLModelConstructor() {
        String generatedClassName = "generatedClassName";
        String name = "newName";
        List<MiningField> miningFields = IntStream.range(0, 3).mapToObj(i -> ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)PMMLModelTestUtils.getRandomMiningField(), (DataField)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List<OutputField> outputFields = IntStream.range(0, 2).mapToObj(i -> ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)PMMLModelTestUtils.getRandomOutputField(), (DataField)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        KiePMMLModelFactoryUtils.setKiePMMLModelConstructor((String)generatedClassName, (ConstructorDeclaration)this.constructorDeclaration, (String)name, miningFields, outputFields);
        this.commonVerifySuperInvocation(generatedClassName, name);
        List<MethodCallExpr> retrieved = this.getMethodCallExprList(this.constructorDeclaration.getBody(), miningFields.size(), "miningFields", "add");
        MethodCallExpr addMethodCall = retrieved.get(0);
        NodeList arguments = addMethodCall.getArguments();
        this.commonVerifyMiningFieldsObjectCreation((List<Expression>)arguments, miningFields);
        retrieved = this.getMethodCallExprList(this.constructorDeclaration.getBody(), outputFields.size(), "outputFields", "add");
        addMethodCall = retrieved.get(0);
        arguments = addMethodCall.getArguments();
        this.commonVerifyOutputFieldsObjectCreation((List<Expression>)arguments, outputFields);
    }

    @Test
    public void addKiePMMLOutputFieldsPopulation() {
        BlockStmt blockStmt = new BlockStmt();
        List outputFields = IntStream.range(0, 3).mapToObj(index -> (KiePMMLOutputField)KiePMMLOutputField.builder((String)("OUTPUTFIELD-" + index), Collections.emptyList()).withRank(Integer.valueOf(new Random().nextInt(3))).withValue((Object)("VALUE-" + index)).withTargetField("TARGETFIELD-" + index).build()).collect(Collectors.toList());
        KiePMMLModelFactoryUtils.addKiePMMLOutputFieldsPopulation((BlockStmt)blockStmt, outputFields);
        List<MethodCallExpr> retrieved = this.getMethodCallExprList(blockStmt, outputFields.size(), "kiePMMLOutputFields", "add");
        for (KiePMMLOutputField outputField : outputFields) {
            Assert.assertTrue((boolean)retrieved.stream().filter(methodCallExpr -> methodCallExpr.getArguments().size() == 1).map(methodCallExpr -> methodCallExpr.getArgument(0)).filter(Expression::isMethodCallExpr).map(expressionArgument -> (MethodCallExpr)expressionArgument).anyMatch(methodCallExpr -> this.evaluateKiePMMLOutputFieldPopulation((MethodCallExpr)methodCallExpr, outputField)));
        }
    }

    @Test
    public void addTransformationsInClassOrInterfaceDeclaration() {
        KiePMMLModelFactoryUtils.addTransformationsInClassOrInterfaceDeclaration((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (TransformationDictionary)pmmlModel.getTransformationDictionary(), (LocalTransformations)model.getLocalTransformations());
        pmmlModel.getTransformationDictionary().getDerivedFields().forEach(derivedField -> this.commonVerifyDerivedFieldTransformation((DerivedField)derivedField, null, "commonTransformationsMap"));
        model.getLocalTransformations().getDerivedFields().forEach(derivedField -> this.commonVerifyDerivedFieldTransformation((DerivedField)derivedField, null, "localTransformationsMap"));
        this.commonVerifyConstructorClass("commonTransformationsMap");
        this.commonVerifyConstructorClass("localTransformationsMap");
    }

    @Test
    public void getMiningFieldsObjectCreations() {
        List<MiningField> miningFields = IntStream.range(0, 3).mapToObj(i -> ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)PMMLModelTestUtils.getRandomMiningField(), (DataField)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List retrieved = KiePMMLModelFactoryUtils.getMiningFieldsObjectCreations(miningFields);
        this.commonVerifyMiningFieldsObjectCreation(retrieved, miningFields);
    }

    @Test
    public void createIntervalsExpression() {
        List intervals = IntStream.range(0, 3).mapToObj(i -> {
            int leftMargin = new Random().nextInt(40);
            int rightMargin = leftMargin + 13;
            return new Interval((Number)leftMargin, (Number)rightMargin);
        }).collect(Collectors.toList());
        Expression retrieved = KiePMMLModelFactoryUtils.createIntervalsExpression(intervals);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof MethodCallExpr));
        MethodCallExpr mtdExp = (MethodCallExpr)retrieved;
        String expected = "java.util.Arrays";
        Assert.assertEquals((Object)expected, (Object)((Expression)mtdExp.getScope().get()).asNameExpr().toString());
        expected = "asList";
        Assert.assertEquals((Object)expected, (Object)mtdExp.getName().asString());
        NodeList arguments = mtdExp.getArguments();
        Assert.assertEquals((long)intervals.size(), (long)arguments.size());
        arguments.forEach(argument -> {
            Assert.assertTrue((boolean)(argument instanceof ObjectCreationExpr));
            ObjectCreationExpr objCrt = (ObjectCreationExpr)argument;
            Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)objCrt.getType().asString());
            Optional<Interval> intervalOpt = intervals.stream().filter(interval -> String.valueOf(interval.getLeftMargin()).equals(objCrt.getArgument(0).asNameExpr().toString()) && String.valueOf(interval.getRightMargin()).equals(objCrt.getArgument(1).asNameExpr().toString())).findFirst();
            Assert.assertTrue((boolean)intervalOpt.isPresent());
        });
    }

    @Test
    public void getObjectCreationExprFromInterval() {
        Interval interval = new Interval(null, (Number)-14);
        ObjectCreationExpr retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)retrieved.getType().asString());
        NodeList arguments = retrieved.getArguments();
        Assert.assertEquals((long)2L, (long)arguments.size());
        Assert.assertTrue((boolean)(arguments.get(0) instanceof NullLiteralExpr));
        Assert.assertEquals((Object)String.valueOf(interval.getRightMargin()), (Object)((Expression)arguments.get(1)).asNameExpr().toString());
        interval = new Interval((Number)-13, (Number)10);
        retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)retrieved.getType().asString());
        arguments = retrieved.getArguments();
        Assert.assertEquals((long)2L, (long)arguments.size());
        Assert.assertEquals((Object)String.valueOf(interval.getLeftMargin()), (Object)((Expression)arguments.get(0)).asNameExpr().toString());
        Assert.assertEquals((Object)String.valueOf(interval.getRightMargin()), (Object)((Expression)arguments.get(1)).asNameExpr().toString());
        interval = new Interval((Number)-13, null);
        retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)retrieved.getType().asString());
        arguments = retrieved.getArguments();
        Assert.assertEquals((long)2L, (long)arguments.size());
        Assert.assertEquals((Object)String.valueOf(interval.getLeftMargin()), (Object)((Expression)arguments.get(0)).asNameExpr().toString());
        Assert.assertTrue((boolean)(arguments.get(1) instanceof NullLiteralExpr));
    }

    @Test
    public void getOutputFieldsObjectCreations() {
        List<OutputField> outputFields = IntStream.range(0, 2).mapToObj(i -> ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)PMMLModelTestUtils.getRandomOutputField(), (DataField)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List retrieved = KiePMMLModelFactoryUtils.getOutputFieldsObjectCreations(outputFields);
        this.commonVerifyOutputFieldsObjectCreation(retrieved, outputFields);
    }

    @Test
    public void populateTransformationsInConstructor() {
        AtomicInteger arityCounter = new AtomicInteger(0);
        Map commonDerivedFieldsMethodMap = DerivedFieldFunctionUtils.getDerivedFieldsMethodMap((List)pmmlModel.getTransformationDictionary().getDerivedFields(), (AtomicInteger)arityCounter);
        Map localDerivedFieldsMethodMap = DerivedFieldFunctionUtils.getDerivedFieldsMethodMap((List)model.getLocalTransformations().getDerivedFields(), (AtomicInteger)arityCounter);
        KiePMMLModelFactoryUtils.populateTransformationsInConstructor((ConstructorDeclaration)this.constructorDeclaration, (Map)commonDerivedFieldsMethodMap, (Map)localDerivedFieldsMethodMap);
        pmmlModel.getTransformationDictionary().getDerivedFields().forEach(derivedField -> this.commonVerifyDerivedFieldTransformation((DerivedField)derivedField, commonDerivedFieldsMethodMap, "commonTransformationsMap"));
        model.getLocalTransformations().getDerivedFields().forEach(derivedField -> this.commonVerifyDerivedFieldTransformation((DerivedField)derivedField, localDerivedFieldsMethodMap, "localTransformationsMap"));
    }

    private void commonVerifyMiningFieldsObjectCreation(List<Expression> toVerify, List<MiningField> miningFields) {
        toVerify.forEach(expression -> {
            Assert.assertTrue((boolean)(expression instanceof ObjectCreationExpr));
            ObjectCreationExpr objCrt = (ObjectCreationExpr)expression;
            Assert.assertEquals((Object)MiningField.class.getCanonicalName(), (Object)objCrt.getType().asString());
            Optional<MiningField> miningFieldOpt = miningFields.stream().filter(miningField -> miningField.getName().equals(objCrt.getArgument(0).asStringLiteralExpr().asString())).findFirst();
            Assert.assertTrue((boolean)miningFieldOpt.isPresent());
            MiningField miningField2 = miningFieldOpt.get();
            Assert.assertEquals((Object)MiningField.class.getCanonicalName(), (Object)objCrt.getType().asString());
            String expected = FIELD_USAGE_TYPE.class.getCanonicalName() + "." + miningField2.getUsageType();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(1).asNameExpr().toString());
            expected = DATA_TYPE.class.getCanonicalName() + "." + miningField2.getDataType();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(3).asNameExpr().toString());
            expected = "java.util.Arrays.asList()";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(5).asMethodCallExpr().toString());
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(6).asMethodCallExpr().toString());
        });
    }

    private void commonVerifyOutputFieldsObjectCreation(List<Expression> toVerify, List<OutputField> outputFields) {
        toVerify.forEach(argument -> {
            Assert.assertTrue((boolean)(argument instanceof ObjectCreationExpr));
            ObjectCreationExpr objCrt = (ObjectCreationExpr)argument;
            Assert.assertEquals((Object)OutputField.class.getCanonicalName(), (Object)objCrt.getType().asString());
            Optional<OutputField> outputFieldOpt = outputFields.stream().filter(miningField -> miningField.getName().equals(objCrt.getArgument(0).asStringLiteralExpr().asString())).findFirst();
            Assert.assertTrue((boolean)outputFieldOpt.isPresent());
            OutputField outputField = outputFieldOpt.get();
            String expected = OP_TYPE.class.getCanonicalName() + "." + outputField.getOpType();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(1).asNameExpr().toString());
            expected = DATA_TYPE.class.getCanonicalName() + "." + outputField.getDataType();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(2).asNameExpr().toString());
            expected = outputField.getTargetField();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(3).asStringLiteralExpr().asString());
            expected = RESULT_FEATURE.class.getCanonicalName() + "." + outputField.getResultFeature();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(4).asNameExpr().toString());
            expected = "java.util.Arrays.asList()";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(5).asMethodCallExpr().toString());
        });
    }

    private void commonVerifySuperInvocation(String generatedClassName, String name) {
        Assert.assertEquals((Object)generatedClassName, (Object)this.constructorDeclaration.getName().asString());
        String expected = String.format("super(\"%s\", Collections.emptyList(), operator, second);", name);
        Assert.assertEquals((Object)expected, (Object)this.superInvocation.toString());
    }

    private void commonVerifyConstructorClass(String mapName) {
        List methodDeclarations = this.classOrInterfaceDeclaration.getMembers().stream().filter(bodyDeclaration -> bodyDeclaration instanceof MethodDeclaration).map(bodyDeclaration -> (MethodDeclaration)bodyDeclaration).collect(Collectors.toList());
        NodeList statements = this.constructorDeclaration.getBody().getStatements();
        statements.stream().filter(statement -> {
            if (!(statement instanceof ExpressionStmt)) {
                return false;
            }
            ExpressionStmt expressionStmt = (ExpressionStmt)statement;
            if (!(expressionStmt.getExpression() instanceof MethodCallExpr)) {
                return false;
            }
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionStmt.getExpression();
            if (!methodCallExpr.getScope().isPresent() || !(methodCallExpr.getScope().get() instanceof NameExpr)) {
                return false;
            }
            NameExpr nameExpr = (NameExpr)methodCallExpr.getScope().get();
            return mapName.equals(nameExpr.getNameAsString());
        }).map(statement -> {
            ExpressionStmt expressionStmt = (ExpressionStmt)statement;
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionStmt.getExpression();
            return (MethodReferenceExpr)methodCallExpr.getArgument(1);
        }).forEach(methodReferenceExpr -> Assert.assertTrue((boolean)methodDeclarations.stream().anyMatch(methodDeclaration -> methodDeclaration.getName().asString().equals(methodReferenceExpr.getIdentifier()))));
    }

    private void commonVerifyDerivedFieldTransformation(DerivedField toVerify, Map<String, MethodDeclaration> derivedFieldsMethodMap, String mapToVerify) {
        NodeList statements = this.constructorDeclaration.getBody().getStatements();
        String fieldName = toVerify.getName().getValue();
        if (derivedFieldsMethodMap != null) {
            this.commonVerifyDerivedFieldMethodMap(toVerify, derivedFieldsMethodMap);
        }
        Assert.assertTrue((boolean)statements.stream().anyMatch(statement -> {
            if (!(statement instanceof ExpressionStmt)) {
                return false;
            }
            ExpressionStmt expressionStmt = (ExpressionStmt)statement;
            if (!(expressionStmt.getExpression() instanceof MethodCallExpr)) {
                return false;
            }
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionStmt.getExpression();
            if (!methodCallExpr.getScope().isPresent() || !(methodCallExpr.getScope().get() instanceof NameExpr)) {
                return false;
            }
            NameExpr nameExpr = (NameExpr)methodCallExpr.getScope().get();
            if (!mapToVerify.equals(nameExpr.getNameAsString())) {
                return false;
            }
            Assert.assertEquals((Object)"put", (Object)methodCallExpr.getName().asString());
            Assert.assertEquals((long)2L, (long)methodCallExpr.getArguments().size());
            Assert.assertTrue((boolean)(methodCallExpr.getArgument(0) instanceof StringLiteralExpr));
            Assert.assertTrue((boolean)(methodCallExpr.getArgument(1) instanceof MethodReferenceExpr));
            if (!fieldName.equals(((StringLiteralExpr)methodCallExpr.getArgument(0)).getValue())) {
                return false;
            }
            Assert.assertTrue((boolean)(((MethodReferenceExpr)methodCallExpr.getArgument(1)).getScope() instanceof ThisExpr));
            if (derivedFieldsMethodMap != null) {
                Assert.assertEquals((Object)((MethodDeclaration)derivedFieldsMethodMap.get(fieldName)).getName().asString(), (Object)((MethodReferenceExpr)methodCallExpr.getArgument(1)).getIdentifier());
            }
            return true;
        }));
    }

    private boolean evaluateKiePMMLOutputFieldPopulation(MethodCallExpr methodCallExpr, KiePMMLOutputField outputField) {
        boolean toReturn = this.commonEvaluateMethodCallExpr(methodCallExpr, "build", (NodeList<Expression>)new NodeList(), MethodCallExpr.class);
        MethodCallExpr resultFeatureScopeExpr = (MethodCallExpr)methodCallExpr.getScope().get();
        NodeList expectedArguments = NodeList.nodeList((Node[])new Expression[]{new NameExpr(RESULT_FEATURE.class.getName() + "." + outputField.getResultFeature().toString())});
        toReturn &= this.commonEvaluateMethodCallExpr(resultFeatureScopeExpr, "withResultFeature", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr targetFieldScopeExpr = (MethodCallExpr)resultFeatureScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr((String)outputField.getTargetField().get())});
        toReturn &= this.commonEvaluateMethodCallExpr(targetFieldScopeExpr, "withTargetField", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr valueScopeExpr = (MethodCallExpr)targetFieldScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getValue().toString())});
        toReturn &= this.commonEvaluateMethodCallExpr(valueScopeExpr, "withValue", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr rankScopeExpr = (MethodCallExpr)valueScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(outputField.getRank().intValue())});
        toReturn &= this.commonEvaluateMethodCallExpr(rankScopeExpr, "withRank", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr builderScopeExpr = (MethodCallExpr)rankScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getName()), new NameExpr("Collections.emptyList()")});
        toReturn &= this.commonEvaluateMethodCallExpr(builderScopeExpr, "builder", (NodeList<Expression>)expectedArguments, NameExpr.class);
        toReturn &= builderScopeExpr.getName().equals((Object)new SimpleName("builder"));
        return toReturn &= ((Expression)builderScopeExpr.getScope().get()).equals((Object)new NameExpr("KiePMMLOutputField"));
    }

    private boolean commonEvaluateMethodCallExpr(MethodCallExpr toEvaluate, String name, NodeList<Expression> expectedArguments, Class<? extends Expression> expectedScopeType) {
        boolean toReturn = Objects.equals(new SimpleName(name), toEvaluate.getName());
        toReturn &= expectedArguments.size() == toEvaluate.getArguments().size();
        for (int i = 0; i < expectedArguments.size(); ++i) {
            toReturn &= ((Expression)expectedArguments.get(i)).equals((Object)toEvaluate.getArgument(i));
        }
        if (expectedScopeType != null) {
            toReturn &= toEvaluate.getScope().isPresent() && ((Expression)toEvaluate.getScope().get()).getClass().equals(expectedScopeType);
        }
        return toReturn;
    }

    private List<MethodCallExpr> getMethodCallExprList(BlockStmt blockStmt, int expectedSize, String scope, String method) {
        Stream<Statement> statementStream = this.getStatementStream(blockStmt);
        List<MethodCallExpr> toReturn = statementStream.filter(Statement::isExpressionStmt).map(expressionStmt -> ((ExpressionStmt)expressionStmt).getExpression()).filter(expression -> expression instanceof MethodCallExpr).map(expression -> (MethodCallExpr)expression).filter(methodCallExpr -> this.evaluateMethodCallExpr((MethodCallExpr)methodCallExpr, scope, method)).collect(Collectors.toList());
        Assert.assertEquals((long)expectedSize, (long)toReturn.size());
        return toReturn;
    }

    private List<MethodCallExpr> getMethodCallExprList(BlockStmt blockStmt, String scope, String method) {
        Stream<Statement> statementStream = this.getStatementStream(blockStmt);
        return statementStream.filter(Statement::isExpressionStmt).map(expressionStmt -> ((ExpressionStmt)expressionStmt).getExpression()).filter(expression -> expression instanceof MethodCallExpr).map(expression -> (MethodCallExpr)expression).filter(methodCallExpr -> this.evaluateMethodCallExpr((MethodCallExpr)methodCallExpr, scope, method)).collect(Collectors.toList());
    }

    private boolean evaluateMethodCallExpr(MethodCallExpr methodCallExpr, String scope, String method) {
        return methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).isNameExpr() && ((NameExpr)methodCallExpr.getScope().get()).getName().asString().equals(scope) && methodCallExpr.getName().asString().equals(method);
    }

    private Stream<Statement> getStatementStream(BlockStmt blockStmt, int expectedSize) {
        NodeList statements = blockStmt.getStatements();
        Assert.assertEquals((long)expectedSize, (long)statements.size());
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(statements.iterator(), 16), false);
    }

    private Stream<Statement> getStatementStream(BlockStmt blockStmt) {
        NodeList statements = blockStmt.getStatements();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(statements.iterator(), 16), false);
    }

    private void commonVerifyDerivedFieldMethodMap(DerivedField toVerify, Map<String, MethodDeclaration> derivedFieldsMethodMap) {
        Assert.assertNotNull(derivedFieldsMethodMap);
        Assert.assertTrue((boolean)derivedFieldsMethodMap.containsKey(toVerify.getName().getValue()));
    }
}

