/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Constant;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLConstantFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLConstantFactoryTest {
    @Test
    public void getConstantVariableDeclaration() {
        String variableName = "variableName";
        Double value = 2342.21;
        Constant constant = new Constant();
        constant.setValue((Object)value);
        BlockStmt retrieved = KiePMMLConstantFactory.getConstantVariableDeclaration((String)variableName, (Constant)constant);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{KiePMMLConstant %1$s = new KiePMMLConstant(\"%1$s\", Collections.emptyList(), %2$s);}", variableName, value));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(KiePMMLConstant.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

