/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDefineFunctionFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLDefineFunctionFactoryTest {
    private static final String CUSTOM_FUNCTION = "CUSTOM_FUNCTION";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;

    @Test
    public void getDefineFunctionVariableDeclaration() {
        ParameterField parameterField1 = new ParameterField(FieldName.create((String)PARAM_1));
        parameterField1.setDataType(DataType.DOUBLE);
        parameterField1.setOpType(OpType.CONTINUOUS);
        parameterField1.setDisplayName("displayName1");
        ParameterField parameterField2 = new ParameterField(FieldName.create((String)PARAM_2));
        parameterField2.setDataType(DataType.DOUBLE);
        parameterField2.setOpType(OpType.CONTINUOUS);
        parameterField2.setDisplayName("displayName2");
        Constant constant = new Constant();
        constant.setValue((Object)value1);
        FieldRef fieldRef = new FieldRef();
        fieldRef.setField(FieldName.create((String)"FIELD_REF"));
        Apply apply = new Apply();
        apply.setFunction("/");
        apply.addExpressions(new Expression[]{constant, fieldRef});
        DefineFunction defineFunction = new DefineFunction();
        defineFunction.setName(CUSTOM_FUNCTION);
        defineFunction.addParameterFields(new ParameterField[]{parameterField1, parameterField2});
        defineFunction.setDataType(DataType.DOUBLE);
        defineFunction.setOpType(OpType.CONTINUOUS);
        defineFunction.setExpression((Expression)apply);
        BlockStmt retrieved = KiePMMLDefineFunctionFactory.getDefineFunctionVariableDeclaration((DefineFunction)defineFunction);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{\n    KiePMMLParameterField CUSTOM_FUNCTION_0 = KiePMMLParameterField.builder(\"%s\", Collections.emptyList()).withDataType(\"%s\").withOpType(\"%s\").withDisplayName(\"%s\").build();\n    KiePMMLParameterField CUSTOM_FUNCTION_1 = KiePMMLParameterField.builder(\"%s\", Collections.emptyList()).withDataType(\"%s\").withOpType(\"%s\").withDisplayName(\"%s\").build();\n    KiePMMLConstant CUSTOM_FUNCTION_Expression_0 = new KiePMMLConstant(\"CUSTOM_FUNCTION_Expression_0\", Collections.emptyList(), %s);\n    KiePMMLFieldRef CUSTOM_FUNCTION_Expression_1 = new KiePMMLFieldRef(\"%s\", Collections.emptyList(), null);\n    KiePMMLApply CUSTOM_FUNCTION_Expression = KiePMMLApply.builder(\"CUSTOM_FUNCTION_Expression\", Collections.emptyList(), \"%s\").withDefaultValue(null).withMapMissingTo(null).withInvalidValueTreatmentMethod(\"%s\").withKiePMMLExpressions(Arrays.asList(CUSTOM_FUNCTION_Expression_0, CUSTOM_FUNCTION_Expression_1)).build();\n    KiePMMLDefineFunction CUSTOM_FUNCTION = new KiePMMLDefineFunction(\"CUSTOM_FUNCTION\", Collections.emptyList(), \"%s\", Arrays.asList(CUSTOM_FUNCTION_0, CUSTOM_FUNCTION_1), CUSTOM_FUNCTION_Expression);\n}", parameterField1.getName().getValue(), parameterField1.getDataType().value(), parameterField1.getOpType().value(), parameterField1.getDisplayName(), parameterField2.getName().getValue(), parameterField2.getDataType().value(), parameterField2.getOpType().value(), parameterField2.getDisplayName(), constant.getValue(), fieldRef.getField().getValue(), apply.getFunction(), apply.getInvalidValueTreatment().value(), defineFunction.getOpType().value()));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(KiePMMLParameterField.class, KiePMMLConstant.class, KiePMMLFieldRef.class, KiePMMLApply.class, KiePMMLDefineFunction.class, Arrays.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

