/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.CLOSURE;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretizeBin;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDiscretizeBinFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLDiscretizeBinFactoryTest {
    @Test
    public void getDiscretizeBinVariableDeclaration() {
        String variableName = "variableName";
        double leftMargin = 45.32;
        Interval interval = new Interval();
        interval.setLeftMargin((Number)leftMargin);
        interval.setRightMargin(null);
        interval.setClosure(Interval.Closure.CLOSED_OPEN);
        String binValue = "binValue";
        DiscretizeBin discretizeBin = new DiscretizeBin();
        discretizeBin.setBinValue((Object)binValue);
        discretizeBin.setInterval(interval);
        BlockStmt retrieved = KiePMMLDiscretizeBinFactory.getDiscretizeBinVariableDeclaration((String)variableName, (DiscretizeBin)discretizeBin);
        String closureString = CLOSURE.class.getName() + "." + CLOSURE.byName((String)interval.getClosure().value()).name();
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{\n    KiePMMLInterval %1$s_Interval = new KiePMMLInterval(%2$s, null, %3$s);\n    KiePMMLDiscretizeBin %1$s = new KiePMMLDiscretizeBin(\"%1$s\", Collections.emptyList(), \"%4$s\", %1$s_Interval);\n}", variableName, leftMargin, closureString, binValue));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Collections.class, KiePMMLDiscretizeBin.class, KiePMMLInterval.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

