/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldColumnPair;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLFieldColumnPairFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLFieldColumnPairFactoryTest {
    @Test
    public void getRowVariableDeclaration() {
        String variableName = "variableName";
        String fieldName = "fieldName";
        String column = "column";
        FieldColumnPair fieldColumnPair = new FieldColumnPair();
        fieldColumnPair.setField(FieldName.create((String)fieldName));
        fieldColumnPair.setColumn(column);
        BlockStmt retrieved = KiePMMLFieldColumnPairFactory.getFieldColumnPairVariableDeclaration((String)variableName, (FieldColumnPair)fieldColumnPair);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{\n    KiePMMLFieldColumnPair %s = new KiePMMLFieldColumnPair(\"%s\", Collections.emptyList(), \"%s\");\n}", variableName, fieldName, column));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Collections.class, KiePMMLFieldColumnPair.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

