/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLFieldRefFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLFieldRefFactoryTest {
    @Test
    public void getFieldRefVariableDeclaration() {
        String variableName = "variableName";
        String fieldName = "fieldName";
        String mapMissingTo = "mapMissingTo";
        FieldRef fieldRef = new FieldRef();
        fieldRef.setField(FieldName.create((String)fieldName));
        fieldRef.setMapMissingTo(mapMissingTo);
        BlockStmt retrieved = KiePMMLFieldRefFactory.getFieldRefVariableDeclaration((String)variableName, (FieldRef)fieldRef);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{KiePMMLFieldRef %1$s = new KiePMMLFieldRef(\"%2$s\", Collections.emptyList(),\"%3$s\");}", variableName, fieldName, mapMissingTo));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(KiePMMLFieldRef.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

