/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.CLOSURE;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLIntervalFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLIntervalFactoryTest {
    @Test
    public void getIntervalVariableDeclaration() {
        String variableName = "variableName";
        double leftMargin = 45.32;
        Interval interval = new Interval();
        interval.setLeftMargin((Number)leftMargin);
        interval.setRightMargin(null);
        interval.setClosure(Interval.Closure.CLOSED_OPEN);
        BlockStmt retrieved = KiePMMLIntervalFactory.getIntervalVariableDeclaration((String)variableName, (Interval)interval);
        String closureString = CLOSURE.class.getName() + "." + CLOSURE.byName((String)interval.getClosure().value()).name();
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{\n    KiePMMLInterval %s = new KiePMMLInterval(%s, null, %s);\n}", variableName, leftMargin, closureString));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Collections.class, KiePMMLInterval.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

