/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dmg.pmml.DataField;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLModelFactoryUtilsTest {
    private static final String SOURCE = "TransformationsSample.pmml";
    private static final String TEMPLATE_SOURCE = "Template.tmpl";
    private static final String TEMPLATE_CLASS_NAME = "Template";
    private static CompilationUnit compilationUnit;
    private static PMML pmmlModel;
    private static TreeModel model;
    private ConstructorDeclaration constructorDeclaration;
    private ExplicitConstructorInvocationStmt superInvocation;
    private ClassOrInterfaceDeclaration classOrInterfaceDeclaration;

    @BeforeClass
    public static void setup() throws Exception {
        pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)SOURCE), (String)"");
        Assert.assertNotNull((Object)pmmlModel);
        model = (TreeModel)pmmlModel.getModels().get(0);
        Assert.assertNotNull((Object)model);
        compilationUnit = JavaParserUtils.getFromFileName((String)TEMPLATE_SOURCE);
    }

    @Before
    public void init() {
        CompilationUnit clonedCompilationUnit = compilationUnit.clone();
        this.constructorDeclaration = (ConstructorDeclaration)((ClassOrInterfaceDeclaration)clonedCompilationUnit.getClassByName(TEMPLATE_CLASS_NAME).orElseThrow(() -> new RuntimeException("Failed to retrieve ClassOrInterfaceDeclaration Template  from Template.tmpl"))).getDefaultConstructor().orElseThrow(() -> new RuntimeException("Failed to retrieve default constructor from Template.tmpl"));
        Assert.assertNotNull((Object)this.constructorDeclaration);
        Assert.assertNotNull((Object)this.constructorDeclaration.getBody());
        Optional optSuperInvocation = CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)this.constructorDeclaration.getBody());
        Assert.assertTrue((boolean)optSuperInvocation.isPresent());
        this.superInvocation = (ExplicitConstructorInvocationStmt)optSuperInvocation.get();
        Assert.assertEquals((Object)TEMPLATE_CLASS_NAME, (Object)this.constructorDeclaration.getName().asString());
        Assert.assertEquals((Object)"super(name, Collections.emptyList(), operator, second);", (Object)this.superInvocation.toString());
        Assert.assertTrue((boolean)clonedCompilationUnit.getClassByName(TEMPLATE_CLASS_NAME).isPresent());
        this.classOrInterfaceDeclaration = ((ClassOrInterfaceDeclaration)clonedCompilationUnit.getClassByName(TEMPLATE_CLASS_NAME).get()).clone();
    }

    @Test
    public void setConstructorSuperNameInvocation() {
        String generatedClassName = "generatedClassName";
        String name = "newName";
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)generatedClassName, (ConstructorDeclaration)this.constructorDeclaration, (String)name);
        this.commonVerifySuperInvocation(generatedClassName, name);
    }

    @Test
    public void setKiePMMLModelConstructor() {
        String generatedClassName = "generatedClassName";
        String name = "newName";
        List<MiningField> miningFields = IntStream.range(0, 3).mapToObj(i -> ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)PMMLModelTestUtils.getRandomMiningField(), (DataField)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List<OutputField> outputFields = IntStream.range(0, 2).mapToObj(i -> ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)PMMLModelTestUtils.getRandomOutputField(), (DataField)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        KiePMMLModelFactoryUtils.setKiePMMLModelConstructor((String)generatedClassName, (ConstructorDeclaration)this.constructorDeclaration, (String)name, miningFields, outputFields, Collections.emptyMap());
        this.commonVerifySuperInvocation(generatedClassName, name);
        List<MethodCallExpr> retrieved = this.getMethodCallExprList(this.constructorDeclaration.getBody(), miningFields.size(), "miningFields", "add");
        MethodCallExpr addMethodCall = retrieved.get(0);
        NodeList arguments = addMethodCall.getArguments();
        this.commonVerifyMiningFieldsObjectCreation((List<Expression>)arguments, miningFields);
        retrieved = this.getMethodCallExprList(this.constructorDeclaration.getBody(), outputFields.size(), "outputFields", "add");
        addMethodCall = retrieved.get(0);
        arguments = addMethodCall.getArguments();
        this.commonVerifyOutputFieldsObjectCreation((List<Expression>)arguments, outputFields);
    }

    @Test
    public void addTransformationsInClassOrInterfaceDeclaration() {
        Assert.assertTrue((boolean)this.classOrInterfaceDeclaration.getMethodsByName("createTransformationDictionary").isEmpty());
        Assert.assertTrue((boolean)this.classOrInterfaceDeclaration.getMethodsByName("createLocalTransformations").isEmpty());
        KiePMMLModelFactoryUtils.addTransformationsInClassOrInterfaceDeclaration((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (TransformationDictionary)pmmlModel.getTransformationDictionary(), (LocalTransformations)model.getLocalTransformations());
        Assert.assertEquals((long)1L, (long)this.classOrInterfaceDeclaration.getMethodsByName("createTransformationDictionary").size());
        Assert.assertEquals((long)1L, (long)this.classOrInterfaceDeclaration.getMethodsByName("createLocalTransformations").size());
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)"private org.kie.pmml.commons.transformations.KiePMMLTransformationDictionary createTransformationDictionary() {\n    KiePMMLParameterField CONSTANT_FUNCTION_0 = KiePMMLParameterField.builder(\"empty\", Collections.emptyList()).withDataType(null).withOpType(null).withDisplayName(null).build();\n    KiePMMLConstant CONSTANT_FUNCTION_Expression = new KiePMMLConstant(\"CONSTANT_FUNCTION_Expression\", Collections.emptyList(), \"CONSTANT_FUNCTION_VALUE\");\n    KiePMMLDefineFunction CONSTANT_FUNCTION = new KiePMMLDefineFunction(\"CONSTANT_FUNCTION\", Collections.emptyList(), \"categorical\", Arrays.asList(CONSTANT_FUNCTION_0), CONSTANT_FUNCTION_Expression);\n    KiePMMLParameterField FIELDREF_FUNCTION_0 = KiePMMLParameterField.builder(\"fieldRed\", Collections.emptyList()).withDataType(null).withOpType(null).withDisplayName(null).build();\n    KiePMMLFieldRef FIELDREF_FUNCTION_Expression = new KiePMMLFieldRef(\"Petal.Length\", Collections.emptyList(), null);\n    KiePMMLDefineFunction FIELDREF_FUNCTION = new KiePMMLDefineFunction(\"FIELDREF_FUNCTION\", Collections.emptyList(), \"continuous\", Arrays.asList(FIELDREF_FUNCTION_0), FIELDREF_FUNCTION_Expression);\n    KiePMMLParameterField APPLY_FUNCTION_0 = KiePMMLParameterField.builder(\"fieldRed\", Collections.emptyList()).withDataType(null).withOpType(null).withDisplayName(null).build();\n    KiePMMLFieldRef APPLY_FUNCTION_Expression_0 = new KiePMMLFieldRef(\"Petal.Length\", Collections.emptyList(), null);\n    KiePMMLApply APPLY_FUNCTION_Expression = KiePMMLApply.builder(\"APPLY_FUNCTION_Expression\", Collections.emptyList(), \"FIELDREF_FUNCTION\").withDefaultValue(null).withMapMissingTo(null).withInvalidValueTreatmentMethod(\"returnInvalid\").withKiePMMLExpressions(Arrays.asList(APPLY_FUNCTION_Expression_0)).build();\n    KiePMMLDefineFunction APPLY_FUNCTION = new KiePMMLDefineFunction(\"APPLY_FUNCTION\", Collections.emptyList(), \"continuous\", Arrays.asList(APPLY_FUNCTION_0), APPLY_FUNCTION_Expression);\n    KiePMMLParameterField TEXT_INDEX_NORMALIZATION_FUNCTION_0 = KiePMMLParameterField.builder(\"reviewText\", Collections.emptyList()).withDataType(null).withOpType(null).withDisplayName(null).build();\n    KiePMMLParameterField TEXT_INDEX_NORMALIZATION_FUNCTION_1 = KiePMMLParameterField.builder(\"term\", Collections.emptyList()).withDataType(null).withOpType(null).withDisplayName(null).build();\n    KiePMMLFieldRef TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_Expression = new KiePMMLFieldRef(\"term\", Collections.emptyList(), null);\n    Map<String, Object> TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_0_columnValues = Stream.of(new Object[][] { { \"regex\", \"true\" }, { \"string\", \"interfaces?\" }, { \"stem\", \"interface\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_0 = new KiePMMLRow(TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_0_columnValues);\n    Map<String, Object> TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_1_columnValues = Stream.of(new Object[][] { { \"regex\", \"true\" }, { \"string\", \"is|are|seem(ed|s?)|were\" }, { \"stem\", \"be\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_1 = new KiePMMLRow(TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_1_columnValues);\n    Map<String, Object> TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_2_columnValues = Stream.of(new Object[][] { { \"regex\", \"true\" }, { \"string\", \"user friendl(y|iness)\" }, { \"stem\", \"user_friendly\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_2 = new KiePMMLRow(TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_2_columnValues);\n    KiePMMLInlineTable TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable = new KiePMMLInlineTable(\"TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable\", Collections.emptyList(), Arrays.asList(TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_0, TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_1, TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable_2));\n    KiePMMLTextIndexNormalization TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0 = KiePMMLTextIndexNormalization.builder(\"TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0\", Collections.emptyList()).withInField(\"string\").withOutField(\"stem\").withKiePMMLInlineTable(TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0_InlineTable).withRegexField(\"regex\").withRecursive(false).withIsCaseSensitive(false).withMaxLevenshteinDistance(null).withWordSeparatorCharacterRE(null).withTokenize(false).build();\n    Map<String, Object> TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_1_InlineTable_0_columnValues = Stream.of(new Object[][] { { \"regex\", \"true\" }, { \"re\", \"interface be (user_friendly|well designed|excellent)\" }, { \"feature\", \"ui_good\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_1_InlineTable_0 = new KiePMMLRow(TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_1_InlineTable_0_columnValues);\n    KiePMMLInlineTable TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_1_InlineTable = new KiePMMLInlineTable(\"TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_1_InlineTable\", Collections.emptyList(), Arrays.asList(TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_1_InlineTable_0));\n    KiePMMLTextIndexNormalization TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_1 = KiePMMLTextIndexNormalization.builder(\"TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_1\", Collections.emptyList()).withInField(\"re\").withOutField(\"feature\").withKiePMMLInlineTable(TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_1_InlineTable).withRegexField(\"regex\").withRecursive(false).withIsCaseSensitive(false).withMaxLevenshteinDistance(null).withWordSeparatorCharacterRE(null).withTokenize(false).build();\n    KiePMMLTextIndex TEXT_INDEX_NORMALIZATION_FUNCTION_Expression = KiePMMLTextIndex.builder(\"reviewText\", Collections.emptyList(), TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_Expression).withLocalTermWeights(org.kie.pmml.api.enums.LOCAL_TERM_WEIGHTS.BINARY).withIsCaseSensitive(false).withMaxLevenshteinDistance(0).withCountHits(org.kie.pmml.api.enums.COUNT_HITS.ALL_HITS).withWordSeparatorCharacterRE(\"\\\\s+\").withTokenize(true).withTextIndexNormalizations(Arrays.asList(TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_0, TEXT_INDEX_NORMALIZATION_FUNCTION_Expression_1)).build();\n    KiePMMLDefineFunction TEXT_INDEX_NORMALIZATION_FUNCTION = new KiePMMLDefineFunction(\"TEXT_INDEX_NORMALIZATION_FUNCTION\", Collections.emptyList(), \"continuous\", Arrays.asList(TEXT_INDEX_NORMALIZATION_FUNCTION_0, TEXT_INDEX_NORMALIZATION_FUNCTION_1), TEXT_INDEX_NORMALIZATION_FUNCTION_Expression);\n    KiePMMLConstant transformationDictionaryDerivedField_0_0 = new KiePMMLConstant(\"transformationDictionaryDerivedField_0_0\", Collections.emptyList(), \"CONSTANT_DERIVEDFIELD_VALUE\");\n    KiePMMLDerivedField transformationDictionaryDerivedField_0 = KiePMMLDerivedField.builder(\"CONSTANT_DERIVEDFIELD\", Collections.emptyList(), \"string\", \"categorical\", transformationDictionaryDerivedField_0_0).withDisplayName(null).build();\n    KiePMMLFieldRef transformationDictionaryDerivedField_1_0_0 = new KiePMMLFieldRef(\"Petal.Length\", Collections.emptyList(), null);\n    KiePMMLApply transformationDictionaryDerivedField_1_0 = KiePMMLApply.builder(\"transformationDictionaryDerivedField_1_0\", Collections.emptyList(), \"APPLY_FUNCTION\").withDefaultValue(null).withMapMissingTo(null).withInvalidValueTreatmentMethod(\"returnInvalid\").withKiePMMLExpressions(Arrays.asList(transformationDictionaryDerivedField_1_0_0)).build();\n    KiePMMLDerivedField transformationDictionaryDerivedField_1 = KiePMMLDerivedField.builder(\"APPLY_DERIVEDFIELD\", Collections.emptyList(), \"double\", \"continuous\", transformationDictionaryDerivedField_1_0).withDisplayName(null).build();\n    KiePMMLFieldRef transformationDictionaryDerivedField_2_0 = new KiePMMLFieldRef(\"Ref\", Collections.emptyList(), null);\n    KiePMMLDerivedField transformationDictionaryDerivedField_2 = KiePMMLDerivedField.builder(\"BackRef\", Collections.emptyList(), \"double\", \"continuous\", transformationDictionaryDerivedField_2_0).withDisplayName(null).build();\n    KiePMMLFieldRef transformationDictionaryDerivedField_3_0 = new KiePMMLFieldRef(\"Petal.Width\", Collections.emptyList(), null);\n    KiePMMLDerivedField transformationDictionaryDerivedField_3 = KiePMMLDerivedField.builder(\"StageOne\", Collections.emptyList(), \"double\", \"continuous\", transformationDictionaryDerivedField_3_0).withDisplayName(null).build();\n    KiePMMLFieldRef transformationDictionaryDerivedField_4_0 = new KiePMMLFieldRef(\"StageOne\", Collections.emptyList(), null);\n    KiePMMLDerivedField transformationDictionaryDerivedField_4 = KiePMMLDerivedField.builder(\"StageTwo\", Collections.emptyList(), \"double\", \"continuous\", transformationDictionaryDerivedField_4_0).withDisplayName(null).build();\n    KiePMMLFieldRef transformationDictionaryDerivedField_5_0 = new KiePMMLFieldRef(\"StageTwo\", Collections.emptyList(), null);\n    KiePMMLDerivedField transformationDictionaryDerivedField_5 = KiePMMLDerivedField.builder(\"StageThree\", Collections.emptyList(), \"double\", \"continuous\", transformationDictionaryDerivedField_5_0).withDisplayName(null).build();\n    KiePMMLFieldColumnPair transformationDictionaryDerivedField_6_0_0 = new KiePMMLFieldColumnPair(\"BAND\", Collections.emptyList(), \"band\");\n    KiePMMLFieldColumnPair transformationDictionaryDerivedField_6_0_1 = new KiePMMLFieldColumnPair(\"STATE\", Collections.emptyList(), \"state\");\n    Map<String, Object> transformationDictionaryDerivedField_6_0_InlineTable_0_columnValues = Stream.of(new Object[][] { { \"band\", \"1\" }, { \"state\", \"MN\" }, { \"out\", \"10000\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow transformationDictionaryDerivedField_6_0_InlineTable_0 = new KiePMMLRow(transformationDictionaryDerivedField_6_0_InlineTable_0_columnValues);\n    Map<String, Object> transformationDictionaryDerivedField_6_0_InlineTable_1_columnValues = Stream.of(new Object[][] { { \"band\", \"1\" }, { \"state\", \"IL\" }, { \"out\", \"12000\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow transformationDictionaryDerivedField_6_0_InlineTable_1 = new KiePMMLRow(transformationDictionaryDerivedField_6_0_InlineTable_1_columnValues);\n    Map<String, Object> transformationDictionaryDerivedField_6_0_InlineTable_2_columnValues = Stream.of(new Object[][] { { \"band\", \"1\" }, { \"state\", \"NY\" }, { \"out\", \"20000\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow transformationDictionaryDerivedField_6_0_InlineTable_2 = new KiePMMLRow(transformationDictionaryDerivedField_6_0_InlineTable_2_columnValues);\n    Map<String, Object> transformationDictionaryDerivedField_6_0_InlineTable_3_columnValues = Stream.of(new Object[][] { { \"band\", \"2\" }, { \"state\", \"MN\" }, { \"out\", \"20000\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow transformationDictionaryDerivedField_6_0_InlineTable_3 = new KiePMMLRow(transformationDictionaryDerivedField_6_0_InlineTable_3_columnValues);\n    Map<String, Object> transformationDictionaryDerivedField_6_0_InlineTable_4_columnValues = Stream.of(new Object[][] { { \"band\", \"2\" }, { \"state\", \"IL\" }, { \"out\", \"23000\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow transformationDictionaryDerivedField_6_0_InlineTable_4 = new KiePMMLRow(transformationDictionaryDerivedField_6_0_InlineTable_4_columnValues);\n    Map<String, Object> transformationDictionaryDerivedField_6_0_InlineTable_5_columnValues = Stream.of(new Object[][] { { \"band\", \"2\" }, { \"state\", \"NY\" }, { \"out\", \"30000\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow transformationDictionaryDerivedField_6_0_InlineTable_5 = new KiePMMLRow(transformationDictionaryDerivedField_6_0_InlineTable_5_columnValues);\n    KiePMMLInlineTable transformationDictionaryDerivedField_6_0_InlineTable = new KiePMMLInlineTable(\"transformationDictionaryDerivedField_6_0_InlineTable\", Collections.emptyList(), Arrays.asList(transformationDictionaryDerivedField_6_0_InlineTable_0, transformationDictionaryDerivedField_6_0_InlineTable_1, transformationDictionaryDerivedField_6_0_InlineTable_2, transformationDictionaryDerivedField_6_0_InlineTable_3, transformationDictionaryDerivedField_6_0_InlineTable_4, transformationDictionaryDerivedField_6_0_InlineTable_5));\n    KiePMMLMapValues transformationDictionaryDerivedField_6_0 = KiePMMLMapValues.builder(\"transformationDictionaryDerivedField_6_0\", Collections.emptyList(), \"out\").withDefaultValue(null).withMapMissingTo(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.INTEGER).withKiePMMLInlineTable(transformationDictionaryDerivedField_6_0_InlineTable).withKiePMMLFieldColumnPairs(Arrays.asList(transformationDictionaryDerivedField_6_0_0, transformationDictionaryDerivedField_6_0_1)).build();\n    KiePMMLDerivedField transformationDictionaryDerivedField_6 = KiePMMLDerivedField.builder(\"mapvalued\", Collections.emptyList(), \"double\", \"continuous\", transformationDictionaryDerivedField_6_0).withDisplayName(null).build();\n    KiePMMLTransformationDictionary transformationDictionary = KiePMMLTransformationDictionary.builder(\"transformationDictionary\", Collections.emptyList()).withDefineFunctions(Arrays.asList(CONSTANT_FUNCTION, FIELDREF_FUNCTION, APPLY_FUNCTION, TEXT_INDEX_NORMALIZATION_FUNCTION)).withDerivedFields(Arrays.asList(transformationDictionaryDerivedField_0, transformationDictionaryDerivedField_1, transformationDictionaryDerivedField_2, transformationDictionaryDerivedField_3, transformationDictionaryDerivedField_4, transformationDictionaryDerivedField_5, transformationDictionaryDerivedField_6)).build();\n    return transformationDictionary;\n}");
        MethodDeclaration retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("createTransformationDictionary").get(0);
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        expected = JavaParserUtils.parseMethod((String)"private org.kie.pmml.commons.transformations.KiePMMLLocalTransformations createLocalTransformations() {\n        KiePMMLConstant localTransformationsDerivedField_0_0 = new KiePMMLConstant(\"localTransformationsDerivedField_0_0\", Collections.emptyList(), \"LOCAL_CONSTANT_DERIVEDFIELD_VALUE\");\n        KiePMMLDerivedField localTransformationsDerivedField_0 = KiePMMLDerivedField.builder(\"LOCAL_CONSTANT_DERIVEDFIELD\", Collections.emptyList(), \"string\", \"categorical\", localTransformationsDerivedField_0_0).withDisplayName(null).build();\n        KiePMMLFieldRef localTransformationsDerivedField_1_0 = new KiePMMLFieldRef(\"Ref\", Collections.emptyList(), null);\n        KiePMMLDerivedField localTransformationsDerivedField_1 = KiePMMLDerivedField.builder(\"LOCAL_Ref\", Collections.emptyList(), \"double\", \"continuous\", localTransformationsDerivedField_1_0).withDisplayName(null).build();\n        KiePMMLFieldRef localTransformationsDerivedField_2_0 = new KiePMMLFieldRef(\"BackRef\", Collections.emptyList(), null);\n        KiePMMLDerivedField localTransformationsDerivedField_2 = KiePMMLDerivedField.builder(\"LOCAL_BackRef\", Collections.emptyList(), \"double\", \"continuous\", localTransformationsDerivedField_2_0).withDisplayName(null).build();\n        KiePMMLLocalTransformations localTransformations = KiePMMLLocalTransformations.builder(\"localTransformations\", Collections.emptyList()).withDerivedFields(Arrays.asList(localTransformationsDerivedField_0, localTransformationsDerivedField_1, localTransformationsDerivedField_2)).build();\n        return localTransformations;\n    }");
        retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("createLocalTransformations").get(0);
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
    }

    @Test
    public void getMiningFieldsObjectCreations() {
        List<MiningField> miningFields = IntStream.range(0, 3).mapToObj(i -> ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)PMMLModelTestUtils.getRandomMiningField(), (DataField)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List retrieved = KiePMMLModelFactoryUtils.getMiningFieldsObjectCreations(miningFields);
        this.commonVerifyMiningFieldsObjectCreation(retrieved, miningFields);
    }

    @Test
    public void createIntervalsExpression() {
        List intervals = IntStream.range(0, 3).mapToObj(i -> {
            int leftMargin = new Random().nextInt(40);
            int rightMargin = leftMargin + 13;
            return new Interval((Number)leftMargin, (Number)rightMargin);
        }).collect(Collectors.toList());
        Expression retrieved = KiePMMLModelFactoryUtils.createIntervalsExpression(intervals);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof MethodCallExpr));
        MethodCallExpr mtdExp = (MethodCallExpr)retrieved;
        String expected = "java.util.Arrays";
        Assert.assertEquals((Object)expected, (Object)((Expression)mtdExp.getScope().get()).asNameExpr().toString());
        expected = "asList";
        Assert.assertEquals((Object)expected, (Object)mtdExp.getName().asString());
        NodeList arguments = mtdExp.getArguments();
        Assert.assertEquals((long)intervals.size(), (long)arguments.size());
        arguments.forEach(argument -> {
            Assert.assertTrue((boolean)(argument instanceof ObjectCreationExpr));
            ObjectCreationExpr objCrt = (ObjectCreationExpr)argument;
            Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)objCrt.getType().asString());
            Optional<Interval> intervalOpt = intervals.stream().filter(interval -> String.valueOf(interval.getLeftMargin()).equals(objCrt.getArgument(0).asNameExpr().toString()) && String.valueOf(interval.getRightMargin()).equals(objCrt.getArgument(1).asNameExpr().toString())).findFirst();
            Assert.assertTrue((boolean)intervalOpt.isPresent());
        });
    }

    @Test
    public void getObjectCreationExprFromInterval() {
        Interval interval = new Interval(null, (Number)-14);
        ObjectCreationExpr retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)retrieved.getType().asString());
        NodeList arguments = retrieved.getArguments();
        Assert.assertEquals((long)2L, (long)arguments.size());
        Assert.assertTrue((boolean)(arguments.get(0) instanceof NullLiteralExpr));
        Assert.assertEquals((Object)String.valueOf(interval.getRightMargin()), (Object)((Expression)arguments.get(1)).asNameExpr().toString());
        interval = new Interval((Number)-13, (Number)10);
        retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)retrieved.getType().asString());
        arguments = retrieved.getArguments();
        Assert.assertEquals((long)2L, (long)arguments.size());
        Assert.assertEquals((Object)String.valueOf(interval.getLeftMargin()), (Object)((Expression)arguments.get(0)).asNameExpr().toString());
        Assert.assertEquals((Object)String.valueOf(interval.getRightMargin()), (Object)((Expression)arguments.get(1)).asNameExpr().toString());
        interval = new Interval((Number)-13, null);
        retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)retrieved.getType().asString());
        arguments = retrieved.getArguments();
        Assert.assertEquals((long)2L, (long)arguments.size());
        Assert.assertEquals((Object)String.valueOf(interval.getLeftMargin()), (Object)((Expression)arguments.get(0)).asNameExpr().toString());
        Assert.assertTrue((boolean)(arguments.get(1) instanceof NullLiteralExpr));
    }

    @Test
    public void getOutputFieldsObjectCreations() {
        List<OutputField> outputFields = IntStream.range(0, 2).mapToObj(i -> ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)PMMLModelTestUtils.getRandomOutputField(), (DataField)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List retrieved = KiePMMLModelFactoryUtils.getOutputFieldsObjectCreations(outputFields);
        this.commonVerifyOutputFieldsObjectCreation(retrieved, outputFields);
    }

    private void commonVerifyMiningFieldsObjectCreation(List<Expression> toVerify, List<MiningField> miningFields) {
        toVerify.forEach(expression -> {
            Assert.assertTrue((boolean)(expression instanceof ObjectCreationExpr));
            ObjectCreationExpr objCrt = (ObjectCreationExpr)expression;
            Assert.assertEquals((Object)MiningField.class.getCanonicalName(), (Object)objCrt.getType().asString());
            Optional<MiningField> miningFieldOpt = miningFields.stream().filter(miningField -> miningField.getName().equals(objCrt.getArgument(0).asStringLiteralExpr().asString())).findFirst();
            Assert.assertTrue((boolean)miningFieldOpt.isPresent());
            MiningField miningField2 = miningFieldOpt.get();
            Assert.assertEquals((Object)MiningField.class.getCanonicalName(), (Object)objCrt.getType().asString());
            String expected = FIELD_USAGE_TYPE.class.getCanonicalName() + "." + miningField2.getUsageType();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(1).asNameExpr().toString());
            expected = DATA_TYPE.class.getCanonicalName() + "." + miningField2.getDataType();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(3).asNameExpr().toString());
            expected = "java.util.Arrays.asList()";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(5).asMethodCallExpr().toString());
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(6).asMethodCallExpr().toString());
        });
    }

    private void commonVerifyOutputFieldsObjectCreation(List<Expression> toVerify, List<OutputField> outputFields) {
        toVerify.forEach(argument -> {
            Assert.assertTrue((boolean)(argument instanceof ObjectCreationExpr));
            ObjectCreationExpr objCrt = (ObjectCreationExpr)argument;
            Assert.assertEquals((Object)OutputField.class.getCanonicalName(), (Object)objCrt.getType().asString());
            Optional<OutputField> outputFieldOpt = outputFields.stream().filter(miningField -> miningField.getName().equals(objCrt.getArgument(0).asStringLiteralExpr().asString())).findFirst();
            Assert.assertTrue((boolean)outputFieldOpt.isPresent());
            OutputField outputField = outputFieldOpt.get();
            String expected = OP_TYPE.class.getCanonicalName() + "." + outputField.getOpType();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(1).asNameExpr().toString());
            expected = DATA_TYPE.class.getCanonicalName() + "." + outputField.getDataType();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(2).asNameExpr().toString());
            expected = outputField.getTargetField();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(3).asStringLiteralExpr().asString());
            expected = RESULT_FEATURE.class.getCanonicalName() + "." + outputField.getResultFeature();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(4).asNameExpr().toString());
            expected = "java.util.Arrays.asList()";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(5).asMethodCallExpr().toString());
        });
    }

    private void commonVerifySuperInvocation(String generatedClassName, String name) {
        Assert.assertEquals((Object)generatedClassName, (Object)this.constructorDeclaration.getName().asString());
        String expected = String.format("super(\"%s\", Collections.emptyList(), operator, second);", name);
        Assert.assertEquals((Object)expected, (Object)this.superInvocation.toString());
    }

    private boolean evaluateKiePMMLOutputFieldPopulation(MethodCallExpr methodCallExpr, KiePMMLOutputField outputField) {
        boolean toReturn = this.commonEvaluateMethodCallExpr(methodCallExpr, "build", (NodeList<Expression>)new NodeList(), MethodCallExpr.class);
        MethodCallExpr resultFeatureScopeExpr = (MethodCallExpr)methodCallExpr.getScope().get();
        NodeList expectedArguments = NodeList.nodeList((Node[])new Expression[]{new NameExpr(RESULT_FEATURE.class.getName() + "." + outputField.getResultFeature().toString())});
        toReturn &= this.commonEvaluateMethodCallExpr(resultFeatureScopeExpr, "withResultFeature", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr targetFieldScopeExpr = (MethodCallExpr)resultFeatureScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr((String)outputField.getTargetField().get())});
        toReturn &= this.commonEvaluateMethodCallExpr(targetFieldScopeExpr, "withTargetField", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr valueScopeExpr = (MethodCallExpr)targetFieldScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getValue().toString())});
        toReturn &= this.commonEvaluateMethodCallExpr(valueScopeExpr, "withValue", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr rankScopeExpr = (MethodCallExpr)valueScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(outputField.getRank().intValue())});
        toReturn &= this.commonEvaluateMethodCallExpr(rankScopeExpr, "withRank", (NodeList<Expression>)expectedArguments, MethodCallExpr.class);
        MethodCallExpr builderScopeExpr = (MethodCallExpr)rankScopeExpr.getScope().get();
        expectedArguments = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getName()), new NameExpr("Collections.emptyList()")});
        toReturn &= this.commonEvaluateMethodCallExpr(builderScopeExpr, "builder", (NodeList<Expression>)expectedArguments, NameExpr.class);
        toReturn &= builderScopeExpr.getName().equals((Object)new SimpleName("builder"));
        return toReturn &= ((Expression)builderScopeExpr.getScope().get()).equals((Object)new NameExpr("KiePMMLOutputField"));
    }

    private boolean commonEvaluateMethodCallExpr(MethodCallExpr toEvaluate, String name, NodeList<Expression> expectedArguments, Class<? extends Expression> expectedScopeType) {
        boolean toReturn = Objects.equals(new SimpleName(name), toEvaluate.getName());
        toReturn &= expectedArguments.size() == toEvaluate.getArguments().size();
        for (int i = 0; i < expectedArguments.size(); ++i) {
            toReturn &= ((Expression)expectedArguments.get(i)).equals((Object)toEvaluate.getArgument(i));
        }
        if (expectedScopeType != null) {
            toReturn &= toEvaluate.getScope().isPresent() && ((Expression)toEvaluate.getScope().get()).getClass().equals(expectedScopeType);
        }
        return toReturn;
    }

    private List<MethodCallExpr> getMethodCallExprList(BlockStmt blockStmt, int expectedSize, String scope, String method) {
        Stream<Statement> statementStream = this.getStatementStream(blockStmt);
        List<MethodCallExpr> toReturn = statementStream.filter(Statement::isExpressionStmt).map(expressionStmt -> ((ExpressionStmt)expressionStmt).getExpression()).filter(expression -> expression instanceof MethodCallExpr).map(expression -> (MethodCallExpr)expression).filter(methodCallExpr -> this.evaluateMethodCallExpr((MethodCallExpr)methodCallExpr, scope, method)).collect(Collectors.toList());
        Assert.assertEquals((long)expectedSize, (long)toReturn.size());
        return toReturn;
    }

    private boolean evaluateMethodCallExpr(MethodCallExpr methodCallExpr, String scope, String method) {
        return methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).isNameExpr() && ((NameExpr)methodCallExpr.getScope().get()).getName().asString().equals(scope) && methodCallExpr.getName().asString().equals(method);
    }

    private Stream<Statement> getStatementStream(BlockStmt blockStmt) {
        NodeList statements = blockStmt.getStatements();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(statements.iterator(), 16), false);
    }
}

