/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.OUTLIER_TREATMENT_METHOD;
import org.kie.pmml.commons.model.expressions.KiePMMLLinearNorm;
import org.kie.pmml.commons.model.expressions.KiePMMLNormContinuous;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLNormContinuousFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLNormContinuousFactoryTest {
    @Test
    public void getNormContinuousVariableDeclaration() {
        String variableName = "variableName";
        String fieldName = "fieldName";
        double mapMissingTo = 45.32;
        LinearNorm ln0 = new LinearNorm((Number)24, (Number)26);
        LinearNorm ln1 = new LinearNorm((Number)30, (Number)32);
        LinearNorm ln2 = new LinearNorm((Number)36, (Number)34);
        LinearNorm ln3 = new LinearNorm((Number)40, (Number)39);
        NormContinuous normContinuous = new NormContinuous();
        normContinuous.setField(FieldName.create((String)fieldName));
        normContinuous.addLinearNorms(new LinearNorm[]{ln0, ln1, ln2, ln3});
        normContinuous.setOutliers(OutlierTreatmentMethod.AS_EXTREME_VALUES);
        normContinuous.setMapMissingTo((Number)mapMissingTo);
        BlockStmt retrieved = KiePMMLNormContinuousFactory.getNormContinuousVariableDeclaration((String)variableName, (NormContinuous)normContinuous);
        String outlierString = OUTLIER_TREATMENT_METHOD.class.getName() + "." + OUTLIER_TREATMENT_METHOD.byName((String)normContinuous.getOutliers().value()).name();
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{\n    KiePMMLNormContinuous %s = new KiePMMLNormContinuous(\"%s\", Collections.emptyList(), Arrays.asList(new KiePMMLLinearNorm(\"LinearNorm-0\", Collections.emptyList(), 24, 26), new KiePMMLLinearNorm(\"LinearNorm-0\", Collections.emptyList(), 30, 32), new KiePMMLLinearNorm(\"LinearNorm-0\", Collections.emptyList(), 36, 34), new KiePMMLLinearNorm(\"LinearNorm-0\", Collections.emptyList(), 40, 39)), %s, %s);\n}", variableName, fieldName, outlierString, mapMissingTo));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLLinearNorm.class, KiePMMLNormContinuous.class, OUTLIER_TREATMENT_METHOD.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    @Test
    public void getNewKiePMMLLinearNormExpression() {
        double orig = 324.3;
        double norm = 325.0;
        String name = "name";
        LinearNorm linearNorm = new LinearNorm((Number)orig, (Number)norm);
        Expression retrieved = KiePMMLNormContinuousFactory.getNewKiePMMLLinearNormExpression((LinearNorm)linearNorm, (String)name);
        Expression expected = JavaParserUtils.parseExpression((String)String.format("new KiePMMLLinearNorm(\"%s\", Collections.emptyList(), %s, %s)", name, orig, norm));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
    }
}

