/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NormDiscrete;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLNormDiscrete;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLNormDiscreteFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLNormDiscreteFactoryTest {
    @Test
    public void getNormDiscreteVariableDeclaration() {
        String variableName = "variableName";
        String fieldName = "fieldName";
        String fieldValue = "fieldValue";
        double mapMissingTo = 45.32;
        NormDiscrete normDiscrete = new NormDiscrete();
        normDiscrete.setField(FieldName.create((String)fieldName));
        normDiscrete.setValue((Object)fieldValue);
        normDiscrete.setMapMissingTo((Number)mapMissingTo);
        BlockStmt retrieved = KiePMMLNormDiscreteFactory.getNormDiscreteVariableDeclaration((String)variableName, (NormDiscrete)normDiscrete);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{\n    KiePMMLNormDiscrete %s = new KiePMMLNormDiscrete(\"%s\", Collections.emptyList(), \"%s\", %s);\n}", variableName, fieldName, fieldValue, mapMissingTo));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Collections.class, KiePMMLNormDiscrete.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

