/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLParameterFieldFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLParameterFieldFactoryTest {
    @Test
    public void getParameterFieldVariableDeclaration() {
        String variableName = "variableName";
        ParameterField parameterField = new ParameterField(FieldName.create((String)variableName));
        parameterField.setDataType(DataType.DOUBLE);
        parameterField.setOpType(OpType.CONTINUOUS);
        parameterField.setDisplayName("displayName");
        BlockStmt retrieved = KiePMMLParameterFieldFactory.getParameterFieldVariableDeclaration((String)variableName, (ParameterField)parameterField);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{\n    KiePMMLParameterField %1$s = KiePMMLParameterField.builder(\"%1$s\", Collections.emptyList()).withDataType(\"%2$s\").withOpType(\"%3$s\").withDisplayName(\"%4$s\").build();\n}", variableName, parameterField.getDataType().value(), parameterField.getOpType().value(), parameterField.getDisplayName()));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(KiePMMLParameterField.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

