/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Row;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLRow;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLRowFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLRowFactoryTest {
    private static final String TRANSFORMATIONS_SAMPLE = "TransformationsSample.pmml";
    private static final String MAPVALUED = "mapvalued";
    private static Row ROW;

    @BeforeClass
    public static void setup() throws Exception {
        PMML pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)TRANSFORMATIONS_SAMPLE), (String)TRANSFORMATIONS_SAMPLE);
        DerivedField mapValued = pmmlModel.getTransformationDictionary().getDerivedFields().stream().filter(derivedField -> MAPVALUED.equals(derivedField.getName().getValue())).findFirst().orElseThrow(() -> new RuntimeException("Missing derived field mapvalued"));
        ROW = (Row)((MapValues)mapValued.getExpression()).getInlineTable().getRows().get(0);
    }

    @Test
    public void getRowVariableDeclaration() {
        String variableName = "variableName";
        BlockStmt retrieved = KiePMMLRowFactory.getRowVariableDeclaration((String)variableName, (Row)ROW);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{\n    Map<String, Object> %1$s_columnValues = Stream.of(new Object[][] { { \"band\", \"1\" }, { \"state\", \"MN\" }, { \"out\", \"10000\" } }).collect(Collectors.toMap(data -> (String) data[0], data -> data[1]));\n    KiePMMLRow %1$s = new KiePMMLRow(%1$s_columnValues);\n}", variableName));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Collectors.class, KiePMMLRow.class, Map.class, Stream.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

