/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.SimplePredicate;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.commons.model.predicates.KiePMMLSimplePredicate;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLSimplePredicateFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLSimplePredicateFactoryTest {
    @Test
    public void getSimplePredicateVariableDeclaration() {
        String variableName = "variableName";
        SimplePredicate simplePredicate = new SimplePredicate();
        simplePredicate.setField(FieldName.create((String)"CUSTOM_FIELD"));
        simplePredicate.setValue((Object)"235.435");
        simplePredicate.setOperator(SimplePredicate.Operator.EQUAL);
        String operatorString = OPERATOR.class.getName() + "." + OPERATOR.byName((String)simplePredicate.getOperator().value());
        DataField dataField = new DataField();
        dataField.setName(simplePredicate.getField());
        dataField.setDataType(DataType.DOUBLE);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        BlockStmt retrieved = KiePMMLSimplePredicateFactory.getSimplePredicateVariableDeclaration((String)variableName, (SimplePredicate)simplePredicate, Collections.emptyList(), (DataDictionary)dataDictionary);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{KiePMMLSimplePredicate %1$s = KiePMMLSimplePredicate.builder(\"%2$s\", Collections.emptyList(), %3$s)\n.withValue(%4$s)\n.build();}", variableName, simplePredicate.getField().getValue(), operatorString, simplePredicate.getValue()));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(KiePMMLSimplePredicate.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

