/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.SimpleSetPredicate;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.ARRAY_TYPE;
import org.kie.pmml.api.enums.IN_NOTIN;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLSimpleSetPredicateFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLSimpleSetPredicateFactoryTest {
    private static final String SIMPLE_SET_PREDICATE_NAME = "SIMPLESETPREDICATENAME";

    @Test
    public void getSimpleSetPredicateVariableDeclaration() {
        String variableName = "variableName";
        Array.Type arrayType = Array.Type.STRING;
        List<String> values = PMMLModelTestUtils.getStringObjects(arrayType, 4);
        SimpleSetPredicate simpleSetPredicate = KiePMMLSimpleSetPredicateFactoryTest.getSimpleSetPredicate(values, arrayType, SimpleSetPredicate.BooleanOperator.IS_IN);
        String arrayTypeString = ARRAY_TYPE.class.getName() + "." + ARRAY_TYPE.byName((String)simpleSetPredicate.getArray().getType().value());
        String booleanOperatorString = IN_NOTIN.class.getName() + "." + IN_NOTIN.byName((String)simpleSetPredicate.getBooleanOperator().value());
        String valuesString = values.stream().map(valueString -> "\"" + valueString + "\"").collect(Collectors.joining(","));
        DataField dataField = new DataField();
        dataField.setName(simpleSetPredicate.getField());
        dataField.setDataType(DataType.DOUBLE);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        BlockStmt retrieved = KiePMMLSimpleSetPredicateFactory.getSimpleSetPredicateVariableDeclaration((String)variableName, (SimpleSetPredicate)simpleSetPredicate, Collections.emptyList(), (DataDictionary)dataDictionary);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format("{KiePMMLSimpleSetPredicate %1$s = KiePMMLSimpleSetPredicate.builder(\"%2$s\", Collections.emptyList(), %3$s, %4$s)\n.withValues(Arrays.asList(%5$s))\n.build();}", variableName, simpleSetPredicate.getField().getValue(), arrayTypeString, booleanOperatorString, valuesString));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(KiePMMLSimpleSetPredicate.class, Arrays.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    public static SimpleSetPredicate getSimpleSetPredicate(List<String> values, Array.Type arrayType, SimpleSetPredicate.BooleanOperator inNotIn) {
        Array array = PMMLModelTestUtils.getArray(arrayType, values);
        SimpleSetPredicate toReturn = new SimpleSetPredicate();
        toReturn.setField(FieldName.create((String)SIMPLE_SET_PREDICATE_NAME));
        toReturn.setBooleanOperator(inNotIn);
        toReturn.setArray(array);
        return toReturn;
    }
}

