/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.implementations;

import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModel;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.commons.mocks.TestModel;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLModelRetrieverTest {
    private static final String MULTIPLE_TARGETS_SOURCE = "MultipleTargetsFieldSample.pmml";
    private static final String ONE_MINING_TARGET_SOURCE = "OneMiningTargetFieldSample.pmml";
    private static final String PACKAGE_NAME = "packagename";
    private PMML pmmlModel;

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)MULTIPLE_TARGETS_SOURCE), (String)MULTIPLE_TARGETS_SOURCE);
        this.pmmlModel.getModels().set(0, new TestModel());
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertTrue((boolean)(retrieved.get() instanceof KiePMMLTestingModel));
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithoutProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithSourcesWithProvider() {
        this.pmmlModel = PMMLModelTestUtils.getPMMLWithRandomTestModel();
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void getFromDataDictionaryAndModelWithSourcesWithoutProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiledWithProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        HasClassLoaderMock hasClassLoaderMock = new HasClassLoaderMock();
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), (HasClassLoader)hasClassLoaderMock);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiledWithoutProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        HasClassLoaderMock hasClassLoaderMock = new HasClassLoaderMock();
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), (HasClassLoader)hasClassLoaderMock);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void getPopulatedWithPMMLModelFields() {
        KiePMMLTestingModel toPopulate = (KiePMMLTestingModel)KiePMMLTestingModel.builder((String)"TESTINGMODEL", Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).build();
        Assert.assertTrue((boolean)toPopulate.getMiningFields().isEmpty());
        Assert.assertTrue((boolean)toPopulate.getOutputFields().isEmpty());
        MiningSchema miningSchema = PMMLModelTestUtils.getRandomMiningSchema();
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields((DataField[])miningSchema.getMiningFields().stream().map(miningField -> PMMLModelTestUtils.getDataField(miningField.getName().getValue(), miningField.getOpType(), PMMLModelTestUtils.getRandomDataType())).toArray(DataField[]::new));
        Output output = PMMLModelTestUtils.getRandomOutput();
        KiePMMLTestingModel populated = (KiePMMLTestingModel)KiePMMLModelRetriever.getPopulatedWithPMMLModelFields((KiePMMLModel)toPopulate, (DataDictionary)dataDictionary, (MiningSchema)miningSchema, (Output)output);
        Assert.assertEquals((long)miningSchema.getMiningFields().size(), (long)populated.getMiningFields().size());
        Assert.assertEquals((long)output.getOutputFields().size(), (long)populated.getOutputFields().size());
        toPopulate = (KiePMMLTestingModel)KiePMMLTestingModel.builder((String)"TESTINGMODEL", Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).build();
        populated = (KiePMMLTestingModel)KiePMMLModelRetriever.getPopulatedWithPMMLModelFields((KiePMMLModel)toPopulate, (DataDictionary)dataDictionary, (MiningSchema)miningSchema, null);
        Assert.assertEquals((long)miningSchema.getMiningFields().size(), (long)populated.getMiningFields().size());
        Assert.assertTrue((boolean)populated.getOutputFields().isEmpty());
        toPopulate = (KiePMMLTestingModel)KiePMMLTestingModel.builder((String)"TESTINGMODEL", Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).build();
        populated = (KiePMMLTestingModel)KiePMMLModelRetriever.getPopulatedWithPMMLModelFields((KiePMMLModel)toPopulate, (DataDictionary)dataDictionary, null, (Output)output);
        Assert.assertTrue((boolean)populated.getMiningFields().isEmpty());
        Assert.assertEquals((long)output.getOutputFields().size(), (long)populated.getOutputFields().size());
        toPopulate = (KiePMMLTestingModel)KiePMMLTestingModel.builder((String)"TESTINGMODEL", Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).build();
        populated = (KiePMMLTestingModel)KiePMMLModelRetriever.getPopulatedWithPMMLModelFields((KiePMMLModel)toPopulate, (DataDictionary)dataDictionary, null, null);
        Assert.assertTrue((boolean)populated.getMiningFields().isEmpty());
        Assert.assertTrue((boolean)populated.getOutputFields().isEmpty());
    }
}

