/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.builders;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.io.InputStream;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.builders.KiePMMLModelCodegenUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLModelCodegenUtilsTest {
    private static final String MODEL_FILE = "TreeSample.pmml";
    private static final String TEST_01_SOURCE = "KiePMMLModelCodegenUtilsTest_01.txt";
    private static final String PACKAGE_NAME = "packagename";
    private static PMML pmml;
    private static Model model;
    private static ClassOrInterfaceDeclaration modelTemplate;

    @BeforeClass
    public static void setup() throws Exception {
        pmml = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)MODEL_FILE), (String)MODEL_FILE);
        model = (Model)pmml.getModels().get(0);
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)"className", (String)"packageName", (String)"KiePMMLTestModelTemplate.tmpl", (String)"KiePMMLTestModelTemplate");
        modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName("className").orElseThrow(() -> new KiePMMLException("Main class not found: className"));
    }

    @Test
    public void init() throws IOException {
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().get();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)PACKAGE_NAME, (PMML)pmml, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLModelCodegenUtils.init((CompilationDTO)compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        BlockStmt body = constructorDeclaration.getBody();
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseConstructorBlock((String)text);
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)body));
    }
}

