/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldColumnPair;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLFieldColumnPairFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLFieldColumnPairFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLFieldColumnPairFactoryTest_01.txt";

    @Test
    public void getRowVariableDeclaration() throws IOException {
        String variableName = "variableName";
        String fieldName = "fieldName";
        String column = "column";
        FieldColumnPair fieldColumnPair = new FieldColumnPair();
        fieldColumnPair.setField(FieldName.create((String)fieldName));
        fieldColumnPair.setColumn(column);
        BlockStmt retrieved = KiePMMLFieldColumnPairFactory.getFieldColumnPairVariableDeclaration((String)variableName, (FieldColumnPair)fieldColumnPair);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, variableName, fieldName, column));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Collections.class, KiePMMLFieldColumnPair.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

