/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.TargetValue;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTargetValueFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLTargetValueFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLTargetValueFactoryTest_01.txt";

    @Test
    public void getKiePMMLTargetValueVariableInitializer() throws IOException {
        KiePMMLTargetValue targetValue = ModelUtils.convertToKiePMMLTargetValue((TargetValue)PMMLModelTestUtils.getRandomTargetValue());
        MethodCallExpr retrieved = KiePMMLTargetValueFactory.getKiePMMLTargetValueVariableInitializer((KiePMMLTargetValue)targetValue);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, targetValue.getName(), targetValue.getValue(), targetValue.getDisplayValue(), targetValue.getPriorProbability(), targetValue.getDefaultValue()));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLTargetValue.class);
        CodegenTestUtils.commonValidateCompilationWithImports((Expression)retrieved, imports);
    }
}

