/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.implementations;

import java.io.InputStream;
import java.util.Optional;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModel;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.mocks.TestModel;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLModelRetrieverTest {
    private static final String MULTIPLE_TARGETS_SOURCE = "MultipleTargetsFieldSample.pmml";
    private static final String ONE_MINING_TARGET_SOURCE = "OneMiningTargetFieldSample.pmml";
    private static final String MINING_MODEL_WITH_NESTED_REFERS_SOURCE = "MiningWithNestedRefers.pmml";
    private PMML pmml;

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithProvider() throws Exception {
        this.pmml = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)MULTIPLE_TARGETS_SOURCE), (String)MULTIPLE_TARGETS_SOURCE);
        TestModel model = new TestModel();
        this.pmml.getModels().set(0, model);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)this.pmml, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertTrue((boolean)(retrieved.get() instanceof KiePMMLTestingModel));
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithoutProvider() throws Exception {
        this.pmml = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)this.pmml, (Model)((Model)this.pmml.getModels().get(0)), (HasClassLoader)new HasClassLoaderMock());
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithSourcesWithProvider() {
        this.pmml = PMMLModelTestUtils.getPMMLWithRandomTestModel();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)this.pmml, (Model)((Model)this.pmml.getModels().get(0)), (HasClassLoader)new HasClassLoaderMock());
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void getFromDataDictionaryAndModelWithSourcesWithoutProvider() throws Exception {
        this.pmml = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)this.pmml, (Model)((Model)this.pmml.getModels().get(0)), (HasClassLoader)new HasClassLoaderMock());
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiledWithProvider() throws Exception {
        this.pmml = PMMLModelTestUtils.getPMMLWithMiningRandomTestModel();
        MiningModel parentModel = (MiningModel)this.pmml.getModels().get(0);
        Model model = ((Segment)parentModel.getSegmentation().getSegments().get(0)).getModel();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)this.pmml, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isPresent());
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiledWithoutProvider() throws Exception {
        this.pmml = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)MINING_MODEL_WITH_NESTED_REFERS_SOURCE), (String)MINING_MODEL_WITH_NESTED_REFERS_SOURCE);
        MiningModel parentModel = (MiningModel)this.pmml.getModels().get(0);
        Model model = ((Segment)parentModel.getSegmentation().getSegments().get(0)).getModel();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)this.pmml, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }
}

