/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Row;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLRow;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLRowFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLRowFactoryTest {
    private static final String TRANSFORMATIONS_SAMPLE = "TransformationsSample.pmml";
    private static final String MAPVALUED = "mapvalued";
    private static final String DATAENCODED = "dataencoded";
    private static final String TEST_01_SOURCE = "KiePMMLRowFactoryTest_01.txt";
    private static final String TEST_02_SOURCE = "KiePMMLRowFactoryTest_02.txt";
    private static Row MAPVALUED_ROW;
    private static Row DATAENCODED_ROW;

    @BeforeClass
    public static void setup() throws Exception {
        PMML pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)TRANSFORMATIONS_SAMPLE), (String)TRANSFORMATIONS_SAMPLE);
        DerivedField mapValued = pmmlModel.getTransformationDictionary().getDerivedFields().stream().filter(derivedField -> MAPVALUED.equals(derivedField.getName().getValue())).findFirst().orElseThrow(() -> new RuntimeException("Missing derived field mapvalued"));
        MAPVALUED_ROW = (Row)((MapValues)mapValued.getExpression()).getInlineTable().getRows().get(0);
        DerivedField dataEncoded = pmmlModel.getTransformationDictionary().getDerivedFields().stream().filter(derivedField -> DATAENCODED.equals(derivedField.getName().getValue())).findFirst().orElseThrow(() -> new RuntimeException("Missing derived field mapvalued"));
        DATAENCODED_ROW = (Row)((MapValues)dataEncoded.getExpression()).getInlineTable().getRows().get(0);
    }

    @Test
    public void getMappedValueRowVariableDeclaration() throws IOException {
        String variableName = "variableName";
        BlockStmt retrieved = KiePMMLRowFactory.getRowVariableDeclaration((String)variableName, (Row)MAPVALUED_ROW);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, variableName));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Collectors.class, KiePMMLRow.class, Map.class, Stream.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    @Test
    public void getDataEncodedRowVariableDeclaration() throws IOException {
        String variableName = "variableName";
        BlockStmt retrieved = KiePMMLRowFactory.getRowVariableDeclaration((String)variableName, (Row)DATAENCODED_ROW);
        String text = FileUtils.getFileContent((String)TEST_02_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, variableName));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Collectors.class, KiePMMLRow.class, Map.class, Stream.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

