/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.text.StringEscapeUtils;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Interval;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Row;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.True;
import org.junit.Assert;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLMiningField;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretize;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretizeBin;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldColumnPair;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.model.expressions.KiePMMLInlineTable;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;
import org.kie.pmml.commons.model.expressions.KiePMMLLinearNorm;
import org.kie.pmml.commons.model.expressions.KiePMMLMapValues;
import org.kie.pmml.commons.model.expressions.KiePMMLNormContinuous;
import org.kie.pmml.commons.model.expressions.KiePMMLNormDiscrete;
import org.kie.pmml.commons.model.expressions.KiePMMLRow;
import org.kie.pmml.commons.model.expressions.KiePMMLTextIndex;
import org.kie.pmml.commons.model.expressions.KiePMMLTextIndexNormalization;
import org.kie.pmml.commons.model.predicates.KiePMMLCompoundPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLFalsePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimplePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLTruePredicate;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;

public class InstanceFactoriesTestCommon {
    static void commonVerifyKiePMMLDefineFunction(KiePMMLDefineFunction toVerify, DefineFunction source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getName(), (Object)toVerify.getName());
        DATA_TYPE expectedDataType = DATA_TYPE.byName((String)source.getDataType().value());
        Assert.assertEquals((Object)expectedDataType, (Object)toVerify.getDataType());
        OP_TYPE expectedOpType = OP_TYPE.byName((String)source.getOpType().value());
        Assert.assertEquals((Object)expectedOpType, (Object)toVerify.getOpType());
        InstanceFactoriesTestCommon.commonVerifyKiePMMLExpression(toVerify.getKiePMMLExpression(), source.getExpression());
        List sourcesParameterFields = source.getParameterFields();
        List toVerifyList = toVerify.getParameterFields();
        Assert.assertEquals((long)sourcesParameterFields.size(), (long)toVerifyList.size());
        sourcesParameterFields.forEach(paramSource -> {
            Optional<KiePMMLParameterField> parameterToVerify = toVerifyList.stream().filter(param -> param.getName().equals(paramSource.getName().getValue())).findFirst();
            Assert.assertTrue((boolean)parameterToVerify.isPresent());
            InstanceFactoriesTestCommon.commonVerifyKiePMMLParameterField(parameterToVerify.get(), paramSource);
        });
    }

    static void commonVerifyKiePMMLDerivedField(KiePMMLDerivedField toVerify, DerivedField source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getName().getValue(), (Object)toVerify.getName());
        DATA_TYPE expectedDataType = DATA_TYPE.byName((String)source.getDataType().value());
        Assert.assertEquals((Object)expectedDataType, (Object)toVerify.getDataType());
        OP_TYPE expectedOpType = OP_TYPE.byName((String)source.getOpType().value());
        Assert.assertEquals((Object)expectedOpType, (Object)toVerify.getOpType());
        String expectedDisplayName = "Display-" + source.getName().getValue();
        Assert.assertEquals((Object)expectedDisplayName, (Object)toVerify.getDisplayName());
        InstanceFactoriesTestCommon.commonVerifyKiePMMLExpression(toVerify.getKiePMMLExpression(), source.getExpression());
    }

    static void commonVerifyKiePMMLParameterField(KiePMMLParameterField toVerify, ParameterField source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getName().getValue(), (Object)toVerify.getName());
        DATA_TYPE expectedDataType = DATA_TYPE.byName((String)source.getDataType().value());
        Assert.assertEquals((Object)expectedDataType, (Object)toVerify.getDataType());
        OP_TYPE expectedOpType = OP_TYPE.byName((String)source.getOpType().value());
        Assert.assertEquals((Object)expectedOpType, (Object)toVerify.getOpType());
        String expectedDisplayName = "Display-" + source.getName().getValue();
        Assert.assertEquals((Object)expectedDisplayName, (Object)toVerify.getDisplayName());
    }

    static void commonVerifyKiePMMLPredicate(KiePMMLPredicate toVerify, Predicate source) {
        switch (source.getClass().getSimpleName()) {
            case "CompoundPredicate": {
                InstanceFactoriesTestCommon.commonVerifyKKiePMMLCompoundPredicate((KiePMMLCompoundPredicate)toVerify, (CompoundPredicate)source);
                break;
            }
            case "False": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLFalsePredicate((KiePMMLFalsePredicate)toVerify, (False)source);
                break;
            }
            case "SimplePredicate": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLSimplePredicate((KiePMMLSimplePredicate)toVerify, (SimplePredicate)source);
                break;
            }
            case "SimpleSetPredicate": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLSimpleSetPredicate((KiePMMLSimpleSetPredicate)toVerify, (SimpleSetPredicate)source);
                break;
            }
            case "True": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLTruePredicate((KiePMMLTruePredicate)toVerify, (True)source);
                break;
            }
            default: {
                Assert.fail((String)String.format("Predicate %s not managed", source.getClass()));
            }
        }
    }

    static void commonVerifyKKiePMMLCompoundPredicate(KiePMMLCompoundPredicate toVerify, CompoundPredicate source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getBooleanOperator().value(), (Object)toVerify.getBooleanOperator().getName());
        Assert.assertEquals((long)source.getPredicates().size(), (long)toVerify.getKiePMMLPredicates().size());
        IntStream.range(0, source.getPredicates().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLPredicate((KiePMMLPredicate)toVerify.getKiePMMLPredicates().get(i), (Predicate)source.getPredicates().get(i)));
    }

    static void commonVerifyKiePMMLFalsePredicate(KiePMMLFalsePredicate toVerify, False source) {
        Assert.assertNotNull((Object)toVerify);
    }

    static void commonVerifyKiePMMLSimplePredicate(KiePMMLSimplePredicate toVerify, SimplePredicate source, DataField dataField) {
        Assert.assertNotNull((Object)toVerify);
        Object value = DATA_TYPE.byName((String)dataField.getDataType().value()).getActualValue(source.getValue());
        Assert.assertEquals((Object)source.getField().getValue(), (Object)toVerify.getName());
        Assert.assertEquals((Object)value, (Object)toVerify.getValue());
        Assert.assertEquals((Object)source.getOperator().value(), (Object)toVerify.getOperator().getName());
    }

    static void commonVerifyKiePMMLSimplePredicate(KiePMMLSimplePredicate toVerify, SimplePredicate source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getField().getValue(), (Object)toVerify.getName());
        Assert.assertEquals((Object)source.getOperator().value(), (Object)toVerify.getOperator().getName());
    }

    static void commonVerifyKiePMMLSimpleSetPredicate(KiePMMLSimpleSetPredicate toVerify, SimpleSetPredicate source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getField().getValue(), (Object)toVerify.getName());
        Array array = source.getArray();
        Assert.assertEquals((Object)array.getType().value(), (Object)toVerify.getArrayType().getName());
        Assert.assertEquals((Object)source.getBooleanOperator().value(), (Object)toVerify.getInNotIn().getName());
        Assert.assertEquals((long)array.getN().intValue(), (long)toVerify.getValues().size());
        String stringValue = (String)array.getValue();
        String[] valuesArray = stringValue.split(" ");
        IntStream.range(0, array.getN()).forEach(i -> {
            switch (array.getType()) {
                case INT: {
                    Assert.assertEquals((Object)Integer.valueOf(valuesArray[i]), toVerify.getValues().get(i));
                    break;
                }
                case STRING: {
                    Assert.assertEquals((Object)valuesArray[i], toVerify.getValues().get(i));
                    break;
                }
                case REAL: {
                    Assert.assertEquals((Object)Double.valueOf(valuesArray[i]), toVerify.getValues().get(i));
                    break;
                }
                default: {
                    throw new KiePMMLException("Unknown Array " + array.getType());
                }
            }
        });
    }

    static void commonVerifyKiePMMLTruePredicate(KiePMMLTruePredicate toVerify, True source) {
        Assert.assertNotNull((Object)toVerify);
    }

    static void commonVerifyKiePMMLExpression(KiePMMLExpression toVerify, Expression source) {
        switch (source.getClass().getSimpleName()) {
            case "Apply": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLApply((KiePMMLApply)toVerify, (Apply)source);
                break;
            }
            case "Constant": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLConstant((KiePMMLConstant)toVerify, (Constant)source);
                break;
            }
            case "Discretize": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLDiscretize((KiePMMLDiscretize)toVerify, (Discretize)source);
                break;
            }
            case "FieldRef": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLFieldRef((KiePMMLFieldRef)toVerify, (FieldRef)source);
                break;
            }
            case "MapValues": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLMapValues((KiePMMLMapValues)toVerify, (MapValues)source);
                break;
            }
            case "NormContinuous": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLNormContinuous((KiePMMLNormContinuous)toVerify, (NormContinuous)source);
                break;
            }
            case "NormDiscrete": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLNormDiscrete((KiePMMLNormDiscrete)toVerify, (NormDiscrete)source);
                break;
            }
            case "TextIndex": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLTextIndex((KiePMMLTextIndex)toVerify, (TextIndex)source);
                break;
            }
            default: {
                Assert.fail((String)String.format("Expression %s not managed", source.getClass()));
            }
        }
    }

    static void commonVerifyKiePMMLApply(KiePMMLApply toVerify, Apply source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getFunction(), (Object)toVerify.getFunction());
        Assert.assertEquals((Object)source.getMapMissingTo(), (Object)toVerify.getMapMissingTo());
        Assert.assertEquals((Object)source.getDefaultValue(), (Object)toVerify.getDefaultValue());
        Assert.assertEquals((Object)source.getInvalidValueTreatment().value(), (Object)toVerify.getInvalidValueTreatmentMethod().getName());
        List kiePMMLExpressionList = toVerify.getKiePMMLExpressions();
        Assert.assertEquals((long)source.getExpressions().size(), (long)kiePMMLExpressionList.size());
        IntStream.range(0, source.getExpressions().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLExpression((KiePMMLExpression)kiePMMLExpressionList.get(i), (Expression)source.getExpressions().get(i)));
    }

    static void commonVerifyKiePMMLConstant(KiePMMLConstant toVerify, Constant source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getValue(), (Object)toVerify.getValue());
    }

    static void commonVerifyKiePMMLDiscretize(KiePMMLDiscretize toVerify, Discretize source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getField().getValue(), (Object)toVerify.getName());
        Assert.assertEquals((Object)source.getMapMissingTo(), (Object)toVerify.getMapMissingTo());
        Assert.assertEquals((Object)source.getDefaultValue(), (Object)toVerify.getDefaultValue());
        Assert.assertEquals((Object)source.getDataType().value(), (Object)toVerify.getDataType().getName());
        Assert.assertEquals((long)source.getDiscretizeBins().size(), (long)toVerify.getDiscretizeBins().size());
        IntStream.range(0, source.getDiscretizeBins().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLDiscretizeBin((KiePMMLDiscretizeBin)toVerify.getDiscretizeBins().get(i), (DiscretizeBin)source.getDiscretizeBins().get(i)));
    }

    static void commonVerifyKiePMMLFieldRef(KiePMMLFieldRef toVerify, FieldRef source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getField().getValue(), (Object)toVerify.getName());
        Assert.assertEquals((Object)source.getMapMissingTo(), (Object)toVerify.getMapMissingTo());
    }

    static void commonVerifyKiePMMLMapValues(KiePMMLMapValues toVerify, MapValues source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getOutputColumn(), (Object)toVerify.getOutputColumn());
        Assert.assertEquals((Object)source.getMapMissingTo(), (Object)toVerify.getMapMissingTo());
        Assert.assertEquals((Object)source.getDefaultValue().toString(), (Object)toVerify.getDefaultValue());
        Assert.assertEquals((Object)source.getDataType().value(), (Object)toVerify.getDataType().getName());
        InstanceFactoriesTestCommon.commonVerifyKiePMMLInlineTableWithCells(toVerify.getInlineTable(), source.getInlineTable());
        Assert.assertEquals((long)source.getFieldColumnPairs().size(), (long)toVerify.getFieldColumnPairs().size());
        IntStream.range(0, source.getFieldColumnPairs().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLFieldColumnPair((KiePMMLFieldColumnPair)toVerify.getFieldColumnPairs().get(i), (FieldColumnPair)source.getFieldColumnPairs().get(i)));
    }

    static void commonVerifyKiePMMLNormContinuous(KiePMMLNormContinuous toVerify, NormContinuous source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getOutliers().value(), (Object)toVerify.getOutlierTreatmentMethod().getName());
        Assert.assertEquals((Object)source.getMapMissingTo(), (Object)toVerify.getMapMissingTo());
        List toConvertLinearNorms = source.getLinearNorms();
        InstanceFactoriesTestCommon.sortLinearNorms(toConvertLinearNorms);
        List retrievedLinearNorms = toVerify.getLinearNorms();
        Assert.assertEquals((long)toConvertLinearNorms.size(), (long)retrievedLinearNorms.size());
        IntStream.range(0, toConvertLinearNorms.size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLLinearNorm((KiePMMLLinearNorm)retrievedLinearNorms.get(i), (LinearNorm)toConvertLinearNorms.get(i)));
    }

    static void commonVerifyKiePMMLNormDiscrete(KiePMMLNormDiscrete toVerify, NormDiscrete source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getField().getValue(), (Object)toVerify.getName());
        Assert.assertEquals((Object)source.getMapMissingTo(), (Object)toVerify.getMapMissingTo());
        Assert.assertEquals((Object)source.getValue().toString(), (Object)toVerify.getValue());
    }

    static void commonVerifyKiePMMLTextIndex(KiePMMLTextIndex toVerify, TextIndex source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getLocalTermWeights().value(), (Object)toVerify.getLocalTermWeights().getName());
        Assert.assertEquals((Object)source.getCountHits().value(), (Object)toVerify.getCountHits().getName());
        Assert.assertEquals((Object)StringEscapeUtils.escapeJava((String)source.getWordSeparatorCharacterRE()), (Object)toVerify.getWordSeparatorCharacterRE());
        InstanceFactoriesTestCommon.commonVerifyKiePMMLExpression(toVerify.getExpression(), source.getExpression());
        Assert.assertEquals((long)source.getTextIndexNormalizations().size(), (long)toVerify.getTextIndexNormalizations().size());
        IntStream.range(0, source.getTextIndexNormalizations().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLTextIndexNormalization((KiePMMLTextIndexNormalization)toVerify.getTextIndexNormalizations().get(i), (TextIndexNormalization)source.getTextIndexNormalizations().get(i)));
        Assert.assertEquals((Object)source.isCaseSensitive(), (Object)toVerify.isCaseSensitive());
        Assert.assertEquals((long)source.getMaxLevenshteinDistance().intValue(), (long)toVerify.getMaxLevenshteinDistance());
        Assert.assertEquals((Object)source.isTokenize(), (Object)toVerify.isTokenize());
    }

    static void commonVerifyKiePMMLTextIndexNormalization(KiePMMLTextIndexNormalization toVerify, TextIndexNormalization source) {
        Assert.assertNotNull((Object)toVerify);
    }

    static void commonVerifyKiePMMLDiscretizeBin(KiePMMLDiscretizeBin toVerify, DiscretizeBin source) {
        Assert.assertNotNull((Object)toVerify);
        InstanceFactoriesTestCommon.commonVerifyKiePMMLInterval(toVerify.getInterval(), source.getInterval());
        Assert.assertEquals((Object)source.getBinValue(), (Object)toVerify.getBinValue());
    }

    static void commonVerifyKiePMMLFieldColumnPair(KiePMMLFieldColumnPair toVerify, FieldColumnPair source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getField().getValue(), (Object)toVerify.getName());
        Assert.assertEquals((Object)source.getColumn(), (Object)toVerify.getColumn());
    }

    static void commonVerifyKiePMMLInlineTableWithCells(KiePMMLInlineTable toVerify, InlineTable source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((long)source.getRows().size(), (long)toVerify.getRows().size());
        IntStream.range(0, source.getRows().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLRowWithCells((KiePMMLRow)toVerify.getRows().get(i), (Row)source.getRows().get(i)));
    }

    static void commonVerifyKiePMMLInterval(KiePMMLInterval toVerify, Interval source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getLeftMargin(), (Object)toVerify.getLeftMargin());
        Assert.assertEquals((Object)source.getRightMargin(), (Object)toVerify.getRightMargin());
        Assert.assertEquals((Object)source.getClosure().value(), (Object)toVerify.getClosure().getName());
    }

    static void commonVerifyKiePMMLMiningField(KiePMMLMiningField toVerify, MiningField source, DataField dataField) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getName().getValue(), (Object)toVerify.getName());
        Assert.assertEquals((Object)source.getOpType().value(), (Object)toVerify.getOpType().getName());
        Assert.assertEquals((Object)source.getUsageType().value(), (Object)toVerify.getFieldUsageType().getName());
        Assert.assertEquals((Object)source.getInvalidValueTreatment().value(), (Object)toVerify.getInvalidValueTreatmentMethod().getName());
        Assert.assertEquals((Object)source.getMissingValueTreatment().value(), (Object)toVerify.getMissingValueTreatmentMethod().getName());
        Assert.assertEquals((Object)source.getInvalidValueReplacement(), (Object)toVerify.getInvalidValueReplacement());
        Assert.assertEquals((Object)source.getMissingValueReplacement(), (Object)toVerify.getMissingValueReplacement());
        Assert.assertEquals((Object)dataField.getDataType().value(), (Object)toVerify.getDataType().getName());
        Assert.assertEquals((long)dataField.getIntervals().size(), (long)toVerify.getIntervals().size());
        IntStream.range(0, dataField.getIntervals().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLInterval((KiePMMLInterval)toVerify.getIntervals().get(i), (Interval)dataField.getIntervals().get(i)));
    }

    static void commonVerifyKiePMMLOutputField(KiePMMLOutputField toVerify, OutputField source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getName().getValue(), (Object)toVerify.getName());
        Assert.assertEquals((Object)source.getValue(), (Object)toVerify.getValue());
        Assert.assertEquals((Object)source.getDataType().value(), (Object)toVerify.getDataType().getName());
        Assert.assertEquals((Object)source.getTargetField().getValue(), toVerify.getTargetField().get());
        Assert.assertEquals((Object)source.getResultFeature().value(), (Object)toVerify.getResultFeature().getName());
        Assert.assertEquals((Object)source.getRank(), (Object)toVerify.getRank());
        Assert.assertEquals((Object)source.getValue(), (Object)toVerify.getValue());
        InstanceFactoriesTestCommon.commonVerifyKiePMMLExpression(toVerify.getKiePMMLExpression(), source.getExpression());
    }

    static void commonVerifyKiePMMLTarget(KiePMMLTarget toVerify, Target source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((long)toVerify.getTargetValues().size(), (long)source.getTargetValues().size());
        OP_TYPE expectedOpType = OP_TYPE.byName((String)source.getOpType().value());
        Assert.assertEquals((Object)expectedOpType, (Object)toVerify.getOpType());
        Assert.assertEquals((Object)source.getField().getValue(), (Object)toVerify.getField());
        CAST_INTEGER expectedCastInteger = CAST_INTEGER.byName((String)source.getCastInteger().value());
        Assert.assertEquals((Object)expectedCastInteger, (Object)toVerify.getCastInteger());
        Assert.assertEquals((double)source.getMin().doubleValue(), (double)toVerify.getMin(), (double)0.0);
        Assert.assertEquals((double)source.getMax().doubleValue(), (double)toVerify.getMax(), (double)0.0);
        Assert.assertEquals((double)source.getRescaleConstant().doubleValue(), (double)toVerify.getRescaleConstant(), (double)0.0);
        Assert.assertEquals((double)source.getRescaleFactor().doubleValue(), (double)toVerify.getRescaleFactor(), (double)0.0);
    }

    static void commonVerifyKiePMMLRow(KiePMMLRow toVerify, Row source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertTrue((boolean)toVerify.getColumnValues().isEmpty());
    }

    static void commonVerifyKiePMMLRowWithCells(KiePMMLRow toVerify, Row source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((long)2L, (long)toVerify.getColumnValues().size());
    }

    static void commonVerifyKiePMMLTargetValue(KiePMMLTargetValue toVerify, TargetValue source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((Object)source.getValue().toString(), (Object)toVerify.getValue());
        Assert.assertEquals((Object)source.getDisplayValue(), (Object)toVerify.getDisplayValue());
        Assert.assertEquals((double)source.getPriorProbability().doubleValue(), (double)toVerify.getPriorProbability(), (double)0.0);
        Assert.assertEquals((double)source.getDefaultValue().doubleValue(), (double)toVerify.getDefaultValue(), (double)0.0);
    }

    static void commonVerifyKiePMMLLinearNorm(KiePMMLLinearNorm toVerify, LinearNorm source) {
        Assert.assertNotNull((Object)toVerify);
        Assert.assertEquals((double)source.getOrig().doubleValue(), (double)toVerify.getOrig(), (double)0.0);
        Assert.assertEquals((double)source.getNorm().doubleValue(), (double)toVerify.getNorm(), (double)0.0);
    }

    static void sortLinearNorms(List<LinearNorm> toSort) {
        toSort.sort((o1, o2) -> (int)(o1.getOrig().doubleValue() - o2.getOrig().doubleValue()));
    }
}

