/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.compiler.commons.factories.KiePMMLFactoryFactory;

public class KiePMMLFactoryFactoryTest {
    @Test
    public void getInstantiationExpression() {
        String kiePMMLModelClass = "org.kie.model.ClassModel";
        Expression retrieved = KiePMMLFactoryFactory.getInstantiationExpression((String)"org.kie.model.ClassModel", (boolean)true);
        this.validateNotCodegen(retrieved, "org.kie.model.ClassModel");
        retrieved = KiePMMLFactoryFactory.getInstantiationExpression((String)"org.kie.model.ClassModel", (boolean)false);
        this.validateCodegen(retrieved, "org.kie.model.ClassModel");
    }

    private void validateNotCodegen(Expression toValidate, String kiePMMLModelClass) {
        Assert.assertNotNull((Object)toValidate);
        Assert.assertTrue((boolean)(toValidate instanceof MethodCallExpr));
        MethodCallExpr methodCallExpr = (MethodCallExpr)toValidate;
        Assert.assertEquals((Object)kiePMMLModelClass, (Object)((Expression)methodCallExpr.getScope().get()).asNameExpr().toString());
        Assert.assertEquals((Object)"getModel", (Object)methodCallExpr.getName().asString());
    }

    private void validateCodegen(Expression toValidate, String kiePMMLModelClass) {
        Assert.assertNotNull((Object)toValidate);
        Assert.assertTrue((boolean)(toValidate instanceof ObjectCreationExpr));
        ObjectCreationExpr objectCreationExpr = (ObjectCreationExpr)toValidate;
        Assert.assertEquals((Object)kiePMMLModelClass, (Object)objectCreationExpr.getType().asString());
    }
}

