/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dmg.pmml.LocalTransformations;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.commons.transformations.KiePMMLLocalTransformations;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.factories.InstanceFactoriesTestCommon;
import org.kie.pmml.compiler.commons.factories.KiePMMLLocalTransformationsInstanceFactory;

public class KiePMMLLocalTransformationsInstanceFactoryTest {
    @Test
    public void getKiePMMLLocalTransformations() {
        LocalTransformations toConvert = PMMLModelTestUtils.getRandomLocalTransformations();
        KiePMMLLocalTransformations retrieved = KiePMMLLocalTransformationsInstanceFactory.getKiePMMLLocalTransformations((LocalTransformations)toConvert, Collections.emptyList());
        Assert.assertNotNull((Object)retrieved);
        List derivedFields = toConvert.getDerivedFields();
        List derivedFieldsToVerify = retrieved.getDerivedFields();
        Assert.assertEquals((long)derivedFields.size(), (long)derivedFieldsToVerify.size());
        derivedFields.forEach(derivedFieldSource -> {
            Optional<KiePMMLDerivedField> derivedFieldToVerify = derivedFieldsToVerify.stream().filter(param -> param.getName().equals(derivedFieldSource.getName().getValue())).findFirst();
            Assert.assertTrue((boolean)derivedFieldToVerify.isPresent());
            InstanceFactoriesTestCommon.commonVerifyKiePMMLDerivedField(derivedFieldToVerify.get(), derivedFieldSource);
        });
    }
}

