/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dmg.pmml.TransformationDictionary;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.commons.transformations.KiePMMLTransformationDictionary;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.factories.InstanceFactoriesTestCommon;
import org.kie.pmml.compiler.commons.factories.KiePMMLTransformationDictionaryInstanceFactory;

public class KiePMMLTransformationDictionaryInstanceFactoryTest {
    @Test
    public void getKiePMMLTransformationDictionary() {
        TransformationDictionary toConvert = PMMLModelTestUtils.getRandomTransformationDictionary();
        KiePMMLTransformationDictionary retrieved = KiePMMLTransformationDictionaryInstanceFactory.getKiePMMLTransformationDictionary((TransformationDictionary)toConvert, Collections.emptyList());
        Assert.assertNotNull((Object)retrieved);
        List derivedFields = toConvert.getDerivedFields();
        List derivedFieldsToVerify = retrieved.getDerivedFields();
        Assert.assertEquals((long)derivedFields.size(), (long)derivedFieldsToVerify.size());
        derivedFields.forEach(derivedFieldSource -> {
            Optional<KiePMMLDerivedField> derivedFieldToVerify = derivedFieldsToVerify.stream().filter(param -> param.getName().equals(derivedFieldSource.getName().getValue())).findFirst();
            Assert.assertTrue((boolean)derivedFieldToVerify.isPresent());
            InstanceFactoriesTestCommon.commonVerifyKiePMMLDerivedField(derivedFieldToVerify.get(), derivedFieldSource);
        });
        List defineFunctions = toConvert.getDefineFunctions();
        List defineFunctionsToVerify = retrieved.getDefineFunctions();
        Assert.assertEquals((long)defineFunctions.size(), (long)defineFunctionsToVerify.size());
        defineFunctions.forEach(defineFunctionSource -> {
            Optional<KiePMMLDefineFunction> defineFunctionToVerify = defineFunctionsToVerify.stream().filter(param -> param.getName().equals(defineFunctionSource.getName())).findFirst();
            Assert.assertTrue((boolean)defineFunctionToVerify.isPresent());
            InstanceFactoriesTestCommon.commonVerifyKiePMMLDefineFunction(defineFunctionToVerify.get(), defineFunctionSource);
        });
    }
}

