/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.MISSING_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLModelFactoryUtilsTest {
    private static final String SOURCE = "TransformationsSample.pmml";
    private static final String TEMPLATE_SOURCE = "Template.tmpl";
    private static final String TEMPLATE_CLASS_NAME = "Template";
    private static final String TEST_01_SOURCE = "KiePMMLModelFactoryUtilsTest_01.txt";
    private static final String TEST_02_SOURCE = "KiePMMLModelFactoryUtilsTest_02.txt";
    private static CompilationUnit compilationUnit;
    private static PMML pmmlModel;
    private static TreeModel model;
    private ConstructorDeclaration constructorDeclaration;
    private ExplicitConstructorInvocationStmt superInvocation;
    private ClassOrInterfaceDeclaration classOrInterfaceDeclaration;

    @BeforeClass
    public static void setup() throws Exception {
        pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)SOURCE), (String)"");
        Assert.assertNotNull((Object)pmmlModel);
        model = (TreeModel)pmmlModel.getModels().get(0);
        Assert.assertNotNull((Object)model);
        compilationUnit = JavaParserUtils.getFromFileName((String)TEMPLATE_SOURCE);
    }

    @Before
    public void init() {
        CompilationUnit clonedCompilationUnit = compilationUnit.clone();
        this.constructorDeclaration = (ConstructorDeclaration)((ClassOrInterfaceDeclaration)clonedCompilationUnit.getClassByName(TEMPLATE_CLASS_NAME).orElseThrow(() -> new RuntimeException("Failed to retrieve ClassOrInterfaceDeclaration Template  from Template.tmpl"))).getDefaultConstructor().orElseThrow(() -> new RuntimeException("Failed to retrieve default constructor from Template.tmpl"));
        Assert.assertNotNull((Object)this.constructorDeclaration);
        Assert.assertNotNull((Object)this.constructorDeclaration.getBody());
        Optional optSuperInvocation = CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)this.constructorDeclaration.getBody());
        Assert.assertTrue((boolean)optSuperInvocation.isPresent());
        this.superInvocation = (ExplicitConstructorInvocationStmt)optSuperInvocation.get();
        Assert.assertEquals((Object)TEMPLATE_CLASS_NAME, (Object)this.constructorDeclaration.getName().asString());
        Assert.assertEquals((Object)"super(name, Collections.emptyList(), operator, second);", (Object)this.superInvocation.toString());
        Assert.assertTrue((boolean)clonedCompilationUnit.getClassByName(TEMPLATE_CLASS_NAME).isPresent());
        this.classOrInterfaceDeclaration = ((ClassOrInterfaceDeclaration)clonedCompilationUnit.getClassByName(TEMPLATE_CLASS_NAME).get()).clone();
    }

    @Test
    public void setConstructorSuperNameInvocation() {
        String generatedClassName = "generatedClassName";
        String name = "newName";
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)generatedClassName, (ConstructorDeclaration)this.constructorDeclaration, (String)name);
        this.commonVerifySuperInvocation(generatedClassName, name);
    }

    @Test
    public void setKiePMMLModelConstructor() {
        String generatedClassName = "generatedClassName";
        String name = "newName";
        List<MiningField> miningFields = IntStream.range(0, 3).mapToObj(i -> ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)PMMLModelTestUtils.getRandomMiningField(), (Field)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List<OutputField> outputFields = IntStream.range(0, 2).mapToObj(i -> ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)PMMLModelTestUtils.getRandomOutputField(), (Field)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        KiePMMLModelFactoryUtils.setKiePMMLModelConstructor((String)generatedClassName, (ConstructorDeclaration)this.constructorDeclaration, (String)name, miningFields, outputFields);
        this.commonVerifySuperInvocation(generatedClassName, name);
        List<MethodCallExpr> retrieved = this.getMethodCallExprList(this.constructorDeclaration.getBody(), miningFields.size(), "miningFields", "add");
        MethodCallExpr addMethodCall = retrieved.get(0);
        NodeList arguments = addMethodCall.getArguments();
        this.commonVerifyMiningFieldsObjectCreation((List<Expression>)arguments, miningFields);
        retrieved = this.getMethodCallExprList(this.constructorDeclaration.getBody(), outputFields.size(), "outputFields", "add");
        addMethodCall = retrieved.get(0);
        arguments = addMethodCall.getArguments();
        this.commonVerifyOutputFieldsObjectCreation((List<Expression>)arguments, outputFields);
    }

    @Test
    public void addTransformationsInClassOrInterfaceDeclaration() throws IOException {
        Assert.assertTrue((boolean)this.classOrInterfaceDeclaration.getMethodsByName("createTransformationDictionary").isEmpty());
        Assert.assertTrue((boolean)this.classOrInterfaceDeclaration.getMethodsByName("createLocalTransformations").isEmpty());
        KiePMMLModelFactoryUtils.addTransformationsInClassOrInterfaceDeclaration((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (TransformationDictionary)pmmlModel.getTransformationDictionary(), (LocalTransformations)model.getLocalTransformations());
        Assert.assertEquals((long)1L, (long)this.classOrInterfaceDeclaration.getMethodsByName("createTransformationDictionary").size());
        Assert.assertEquals((long)1L, (long)this.classOrInterfaceDeclaration.getMethodsByName("createLocalTransformations").size());
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)text);
        MethodDeclaration retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("createTransformationDictionary").get(0);
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        text = FileUtils.getFileContent((String)TEST_02_SOURCE);
        expected = JavaParserUtils.parseMethod((String)text);
        retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("createLocalTransformations").get(0);
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
    }

    @Test
    public void getMiningFieldsObjectCreations() {
        List<MiningField> miningFields = IntStream.range(0, 3).mapToObj(i -> ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)PMMLModelTestUtils.getRandomMiningField(), (Field)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List retrieved = KiePMMLModelFactoryUtils.getMiningFieldsObjectCreations(miningFields);
        this.commonVerifyMiningFieldsObjectCreation(retrieved, miningFields);
    }

    @Test
    public void createIntervalsExpression() {
        List intervals = IntStream.range(0, 3).mapToObj(i -> {
            int leftMargin = new Random().nextInt(40);
            int rightMargin = leftMargin + 13;
            return new Interval((Number)leftMargin, (Number)rightMargin);
        }).collect(Collectors.toList());
        Expression retrieved = KiePMMLModelFactoryUtils.createIntervalsExpression(intervals);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof MethodCallExpr));
        MethodCallExpr mtdExp = (MethodCallExpr)retrieved;
        String expected = "java.util.Arrays";
        Assert.assertEquals((Object)expected, (Object)((Expression)mtdExp.getScope().get()).asNameExpr().toString());
        expected = "asList";
        Assert.assertEquals((Object)expected, (Object)mtdExp.getName().asString());
        NodeList arguments = mtdExp.getArguments();
        Assert.assertEquals((long)intervals.size(), (long)arguments.size());
        arguments.forEach(argument -> {
            Assert.assertTrue((boolean)(argument instanceof ObjectCreationExpr));
            ObjectCreationExpr objCrt = (ObjectCreationExpr)argument;
            Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)objCrt.getType().asString());
            Optional<Interval> intervalOpt = intervals.stream().filter(interval -> String.valueOf(interval.getLeftMargin()).equals(objCrt.getArgument(0).asNameExpr().toString()) && String.valueOf(interval.getRightMargin()).equals(objCrt.getArgument(1).asNameExpr().toString())).findFirst();
            Assert.assertTrue((boolean)intervalOpt.isPresent());
        });
    }

    @Test
    public void getObjectCreationExprFromInterval() {
        Interval interval = new Interval(null, (Number)-14);
        ObjectCreationExpr retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)retrieved.getType().asString());
        NodeList arguments = retrieved.getArguments();
        Assert.assertEquals((long)2L, (long)arguments.size());
        Assert.assertTrue((boolean)(arguments.get(0) instanceof NullLiteralExpr));
        Assert.assertEquals((Object)String.valueOf(interval.getRightMargin()), (Object)((Expression)arguments.get(1)).asNameExpr().toString());
        interval = new Interval((Number)-13, (Number)10);
        retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)retrieved.getType().asString());
        arguments = retrieved.getArguments();
        Assert.assertEquals((long)2L, (long)arguments.size());
        Assert.assertEquals((Object)String.valueOf(interval.getLeftMargin()), (Object)((Expression)arguments.get(0)).asNameExpr().toString());
        Assert.assertEquals((Object)String.valueOf(interval.getRightMargin()), (Object)((Expression)arguments.get(1)).asNameExpr().toString());
        interval = new Interval((Number)-13, null);
        retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)Interval.class.getCanonicalName(), (Object)retrieved.getType().asString());
        arguments = retrieved.getArguments();
        Assert.assertEquals((long)2L, (long)arguments.size());
        Assert.assertEquals((Object)String.valueOf(interval.getLeftMargin()), (Object)((Expression)arguments.get(0)).asNameExpr().toString());
        Assert.assertTrue((boolean)(arguments.get(1) instanceof NullLiteralExpr));
    }

    @Test
    public void getOutputFieldsObjectCreations() {
        List<OutputField> outputFields = IntStream.range(0, 2).mapToObj(i -> ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)PMMLModelTestUtils.getRandomOutputField(), (Field)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List retrieved = KiePMMLModelFactoryUtils.getOutputFieldsObjectCreations(outputFields);
        this.commonVerifyOutputFieldsObjectCreation(retrieved, outputFields);
    }

    private void commonVerifyMiningFieldsObjectCreation(List<Expression> toVerify, List<MiningField> miningFields) {
        toVerify.forEach(expression -> {
            Assert.assertTrue((boolean)(expression instanceof ObjectCreationExpr));
            ObjectCreationExpr objCrt = (ObjectCreationExpr)expression;
            Assert.assertEquals((Object)MiningField.class.getCanonicalName(), (Object)objCrt.getType().asString());
            Optional<MiningField> miningFieldOpt = miningFields.stream().filter(miningField -> miningField.getName().equals(objCrt.getArgument(0).asStringLiteralExpr().asString())).findFirst();
            Assert.assertTrue((boolean)miningFieldOpt.isPresent());
            MiningField miningField2 = miningFieldOpt.get();
            Assert.assertEquals((Object)MiningField.class.getCanonicalName(), (Object)objCrt.getType().asString());
            String expected = miningField2.getUsageType() != null ? FIELD_USAGE_TYPE.class.getCanonicalName() + "." + miningField2.getUsageType() : "null";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(1).toString());
            expected = miningField2.getOpType() != null ? OP_TYPE.class.getCanonicalName() + "." + miningField2.getOpType() : "null";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(2).toString());
            expected = miningField2.getDataType() != null ? DATA_TYPE.class.getCanonicalName() + "." + miningField2.getDataType() : "null";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(3).toString());
            expected = miningField2.getMissingValueTreatmentMethod() != null ? MISSING_VALUE_TREATMENT_METHOD.class.getCanonicalName() + "." + miningField2.getMissingValueTreatmentMethod() : "null";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(4).toString());
            expected = miningField2.getInvalidValueTreatmentMethod() != null ? INVALID_VALUE_TREATMENT_METHOD.class.getCanonicalName() + "." + miningField2.getInvalidValueTreatmentMethod() : "null";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(5).toString());
            expected = miningField2.getMissingValueReplacement() != null ? miningField2.getMissingValueReplacement() : "null";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(6).toString());
            expected = miningField2.getInvalidValueReplacement() != null ? miningField2.getInvalidValueReplacement() : "null";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(7).toString());
            expected = "java.util.Arrays.asList()";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(8).toString());
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(9).toString());
        });
    }

    private void commonVerifyOutputFieldsObjectCreation(List<Expression> toVerify, List<OutputField> outputFields) {
        toVerify.forEach(argument -> {
            Assert.assertTrue((boolean)(argument instanceof ObjectCreationExpr));
            ObjectCreationExpr objCrt = (ObjectCreationExpr)argument;
            Assert.assertEquals((Object)OutputField.class.getCanonicalName(), (Object)objCrt.getType().asString());
            Optional<OutputField> outputFieldOpt = outputFields.stream().filter(miningField -> miningField.getName().equals(objCrt.getArgument(0).asStringLiteralExpr().asString())).findFirst();
            Assert.assertTrue((boolean)outputFieldOpt.isPresent());
            OutputField outputField = outputFieldOpt.get();
            String expected = OP_TYPE.class.getCanonicalName() + "." + outputField.getOpType();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(1).asNameExpr().toString());
            expected = DATA_TYPE.class.getCanonicalName() + "." + outputField.getDataType();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(2).asNameExpr().toString());
            expected = outputField.getTargetField();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(3).asStringLiteralExpr().asString());
            expected = RESULT_FEATURE.class.getCanonicalName() + "." + outputField.getResultFeature();
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(4).asNameExpr().toString());
            expected = "java.util.Arrays.asList()";
            Assert.assertEquals((Object)expected, (Object)objCrt.getArgument(5).asMethodCallExpr().toString());
        });
    }

    private void commonVerifySuperInvocation(String generatedClassName, String name) {
        Assert.assertEquals((Object)generatedClassName, (Object)this.constructorDeclaration.getName().asString());
        String expected = String.format("super(\"%s\", Collections.emptyList(), operator, second);", name);
        Assert.assertEquals((Object)expected, (Object)this.superInvocation.toString());
    }

    private List<MethodCallExpr> getMethodCallExprList(BlockStmt blockStmt, int expectedSize, String scope, String method) {
        Stream<Statement> statementStream = this.getStatementStream(blockStmt);
        List<MethodCallExpr> toReturn = statementStream.filter(Statement::isExpressionStmt).map(expressionStmt -> ((ExpressionStmt)expressionStmt).getExpression()).filter(expression -> expression instanceof MethodCallExpr).map(expression -> (MethodCallExpr)expression).filter(methodCallExpr -> this.evaluateMethodCallExpr((MethodCallExpr)methodCallExpr, scope, method)).collect(Collectors.toList());
        Assert.assertEquals((long)expectedSize, (long)toReturn.size());
        return toReturn;
    }

    private boolean evaluateMethodCallExpr(MethodCallExpr methodCallExpr, String scope, String method) {
        return methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).isNameExpr() && ((NameExpr)methodCallExpr.getScope().get()).getName().asString().equals(scope) && methodCallExpr.getName().asString().equals(method);
    }

    private Stream<Statement> getStatementStream(BlockStmt blockStmt) {
        NodeList statements = blockStmt.getStatements();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(statements.iterator(), 16), false);
    }
}

