/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.mocks;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModel;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModelWithSources;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.mocks.TestModel;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class TestingModelImplementationProvider
implements ModelImplementationProvider<TestModel, KiePMMLTestingModel> {
    public static final String KIE_PMML_TEST_MODEL_TEMPLATE_JAVA = "KiePMMLTestModelTemplate.tmpl";
    public static final String KIE_PMML_TEST_MODEL_TEMPLATE = "KiePMMLTestModelTemplate";

    public PMML_MODEL getPMMLModelType() {
        return KiePMMLTestingModel.PMML_MODEL_TYPE;
    }

    public KiePMMLTestingModel getKiePMMLModel(CompilationDTO<TestModel> compilationDTO) {
        return (KiePMMLTestingModel)KiePMMLTestingModel.builder((String)"TEST_MODEL", Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).build();
    }

    public KiePMMLTestingModel getKiePMMLModelWithSources(CompilationDTO<TestModel> compilationDTO) {
        Map<String, String> sourcesMap = this.getKiePMMLTestModelSourcesMap(compilationDTO);
        return new KiePMMLTestingModelWithSources(compilationDTO.getModelName(), compilationDTO.getPackageName(), sourcesMap);
    }

    private Map<String, String> getKiePMMLTestModelSourcesMap(CompilationDTO<TestModel> compilationDTO) {
        String className = compilationDTO.getSimpleClassName();
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)compilationDTO.getPackageName(), (String)KIE_PMML_TEST_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_TEST_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        String modelName = compilationDTO.getModelName();
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        this.setConstructor(className, constructorDeclaration, modelName);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    private void setConstructor(String generatedClassName, ConstructorDeclaration constructorDeclaration, String modelName) {
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)generatedClassName, (ConstructorDeclaration)constructorDeclaration, (String)modelName);
    }
}

