/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Constant;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLConstantFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLConstantFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLConstantFactoryTest_01.txt";

    @Test
    public void getConstantVariableDeclaration() throws IOException {
        String variableName = "variableName";
        Double value = 2342.21;
        Constant constant = new Constant();
        constant.setValue((Object)value);
        BlockStmt retrieved = KiePMMLConstantFactory.getConstantVariableDeclaration((String)variableName, (Constant)constant);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, variableName, value));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLConstant.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

