/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDefineFunctionFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLDefineFunctionFactoryTest {
    private static final String CUSTOM_FUNCTION = "CUSTOM_FUNCTION";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;
    private static final String TEST_01_SOURCE = "KiePMMLDefineFunctionFactoryTest_01.txt";

    @Test
    public void getDefineFunctionVariableDeclaration() throws IOException {
        ParameterField parameterField1 = new ParameterField(FieldName.create((String)PARAM_1));
        parameterField1.setDataType(DataType.DOUBLE);
        parameterField1.setOpType(OpType.CONTINUOUS);
        parameterField1.setDisplayName("displayName1");
        ParameterField parameterField2 = new ParameterField(FieldName.create((String)PARAM_2));
        parameterField2.setDataType(DataType.DOUBLE);
        parameterField2.setOpType(OpType.CONTINUOUS);
        parameterField2.setDisplayName("displayName2");
        Constant constant = new Constant();
        constant.setValue((Object)value1);
        FieldRef fieldRef = new FieldRef();
        fieldRef.setField(FieldName.create((String)"FIELD_REF"));
        Apply apply = new Apply();
        apply.setFunction("/");
        apply.addExpressions(new Expression[]{constant, fieldRef});
        DefineFunction defineFunction = new DefineFunction();
        defineFunction.setName(CUSTOM_FUNCTION);
        defineFunction.addParameterFields(new ParameterField[]{parameterField1, parameterField2});
        defineFunction.setDataType(DataType.DOUBLE);
        defineFunction.setOpType(OpType.CONTINUOUS);
        defineFunction.setExpression((Expression)apply);
        String dataType1 = CommonTestingUtils.getDATA_TYPEString((DataType)parameterField1.getDataType());
        String dataType2 = CommonTestingUtils.getDATA_TYPEString((DataType)parameterField2.getDataType());
        String dataType3 = CommonTestingUtils.getDATA_TYPEString((DataType)defineFunction.getDataType());
        String opType1 = CommonTestingUtils.getOP_TYPEString((OpType)parameterField1.getOpType());
        String opType2 = CommonTestingUtils.getOP_TYPEString((OpType)parameterField2.getOpType());
        String opType3 = CommonTestingUtils.getOP_TYPEString((OpType)defineFunction.getOpType());
        BlockStmt retrieved = KiePMMLDefineFunctionFactory.getDefineFunctionVariableDeclaration((DefineFunction)defineFunction);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, parameterField1.getName().getValue(), dataType1, opType1, parameterField1.getDisplayName(), parameterField2.getName().getValue(), dataType2, opType2, parameterField2.getDisplayName(), constant.getValue(), fieldRef.getField().getValue(), apply.getFunction(), apply.getInvalidValueTreatment().value(), dataType3, opType3));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLParameterField.class, KiePMMLConstant.class, KiePMMLFieldRef.class, KiePMMLApply.class, KiePMMLDefineFunction.class, Arrays.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

