/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Interval;
import org.junit.Test;
import org.kie.pmml.api.enums.CLOSURE;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretizeBin;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDiscretizeBinFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLDiscretizeBinFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLDiscretizeBinFactoryTest_01.txt";

    @Test
    public void getDiscretizeBinVariableDeclaration() throws IOException {
        String variableName = "variableName";
        double leftMargin = 45.32;
        Interval interval = new Interval();
        interval.setLeftMargin((Number)leftMargin);
        interval.setRightMargin(null);
        interval.setClosure(Interval.Closure.CLOSED_OPEN);
        String binValue = "binValue";
        DiscretizeBin discretizeBin = new DiscretizeBin();
        discretizeBin.setBinValue((Object)binValue);
        discretizeBin.setInterval(interval);
        BlockStmt retrieved = KiePMMLDiscretizeBinFactory.getDiscretizeBinVariableDeclaration((String)variableName, (DiscretizeBin)discretizeBin);
        String closureString = CLOSURE.class.getName() + "." + CLOSURE.byName((String)interval.getClosure().value()).name();
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, variableName, leftMargin, closureString, binValue));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(Collections.class, KiePMMLDiscretizeBin.class, KiePMMLInterval.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

