/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Target;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.MISSING_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.models.TargetField;
import org.kie.pmml.api.models.TargetValue;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLModelFactoryUtilsTest {
    private static final String SOURCE = "TransformationsSample.pmml";
    private static final String TEMPLATE_SOURCE = "Template.tmpl";
    private static final String TEMPLATE_CLASS_NAME = "Template";
    private static final String TEST_01_SOURCE = "KiePMMLModelFactoryUtilsTest_01.txt";
    private static final String TEST_02_SOURCE = "KiePMMLModelFactoryUtilsTest_02.txt";
    private static final String TEST_03_SOURCE = "KiePMMLModelFactoryUtilsTest_03.txt";
    private static final String TEST_04_SOURCE = "KiePMMLModelFactoryUtilsTest_04.txt";
    private static final String TEST_05_SOURCE = "KiePMMLModelFactoryUtilsTest_05.txt";
    private static final String TEST_06_SOURCE = "KiePMMLModelFactoryUtilsTest_06.txt";
    private static final String TEST_07_SOURCE = "KiePMMLModelFactoryUtilsTest_07.txt";
    private static final String TEST_08_SOURCE = "KiePMMLModelFactoryUtilsTest_08.txt";
    private static final String TEST_09_SOURCE = "KiePMMLModelFactoryUtilsTest_09.txt";
    private static final String TEST_10_SOURCE = "KiePMMLModelFactoryUtilsTest_10.txt";
    private static final String TEST_11_SOURCE = "KiePMMLModelFactoryUtilsTest_11.txt";
    private static final String TEST_12_SOURCE = "KiePMMLModelFactoryUtilsTest_12.txt";
    private static final String TEST_13_SOURCE = "KiePMMLModelFactoryUtilsTest_13.txt";
    private static final String TEST_14_SOURCE = "KiePMMLModelFactoryUtilsTest_14.txt";
    private static final String TEST_15_SOURCE = "KiePMMLTargetFactoryTest_01.txt";
    private static CompilationUnit compilationUnit;
    private static PMML pmmlModel;
    private static TreeModel model;
    private ConstructorDeclaration constructorDeclaration;
    private MethodDeclaration staticGetterMethod;
    private ExplicitConstructorInvocationStmt superInvocation;
    private ClassOrInterfaceDeclaration classOrInterfaceDeclaration;

    @BeforeClass
    public static void setup() throws Exception {
        pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)SOURCE), (String)"");
        Assertions.assertThat((Object)pmmlModel).isNotNull();
        model = (TreeModel)pmmlModel.getModels().get(0);
        Assertions.assertThat((Object)model).isNotNull();
        compilationUnit = JavaParserUtils.getFromFileName((String)TEMPLATE_SOURCE);
    }

    @Before
    public void initTest() {
        CompilationUnit clonedCompilationUnit = compilationUnit.clone();
        this.classOrInterfaceDeclaration = ((ClassOrInterfaceDeclaration)clonedCompilationUnit.getClassByName(TEMPLATE_CLASS_NAME).orElseThrow(() -> new RuntimeException("Failed to retrieve ClassOrInterfaceDeclaration Template  from Template.tmpl"))).clone();
        this.constructorDeclaration = (ConstructorDeclaration)this.classOrInterfaceDeclaration.getDefaultConstructor().orElseThrow(() -> new RuntimeException("Failed to retrieve default constructor from Template.tmpl"));
        Assertions.assertThat((Object)this.constructorDeclaration).isNotNull();
        Assertions.assertThat((Object)this.constructorDeclaration.getBody()).isNotNull();
        this.staticGetterMethod = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("getModel").get(0);
        Optional optSuperInvocation = CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)this.constructorDeclaration.getBody());
        Assertions.assertThat((Optional)optSuperInvocation).isPresent();
        this.superInvocation = (ExplicitConstructorInvocationStmt)optSuperInvocation.get();
        Assertions.assertThat((String)this.constructorDeclaration.getName().asString()).isEqualTo(TEMPLATE_CLASS_NAME);
        Assertions.assertThat((String)this.superInvocation.toString()).isEqualTo("super(name, Collections.emptyList(), operator, second);");
        Assertions.assertThat((Optional)clonedCompilationUnit.getClassByName(TEMPLATE_CLASS_NAME)).isPresent();
    }

    @Test
    public void setConstructorSuperNameInvocation() {
        String generatedClassName = "generatedClassName";
        String name = "newName";
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)generatedClassName, (ConstructorDeclaration)this.constructorDeclaration, (String)name);
        this.commonVerifySuperInvocation(generatedClassName, name);
    }

    @Test
    public void setKiePMMLModelConstructor() {
        String generatedClassName = "generatedClassName";
        String name = "newName";
        List<MiningField> miningFields = IntStream.range(0, 3).mapToObj(i -> ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)PMMLModelTestUtils.getRandomMiningField(), (Field)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List<OutputField> outputFields = IntStream.range(0, 2).mapToObj(i -> ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)PMMLModelTestUtils.getRandomOutputField(), (Field)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List<TargetField> targetFields = IntStream.range(0, 2).mapToObj(i -> ModelUtils.convertToKieTargetField((Target)PMMLModelTestUtils.getRandomTarget())).collect(Collectors.toList());
        KiePMMLModelFactoryUtils.setKiePMMLModelConstructor((String)generatedClassName, (ConstructorDeclaration)this.constructorDeclaration, (String)name, miningFields, outputFields, targetFields);
        this.commonVerifySuperInvocation(generatedClassName, name);
        List<MethodCallExpr> retrieved = this.getMethodCallExprList(this.constructorDeclaration.getBody(), miningFields.size(), "miningFields", "add");
        MethodCallExpr addMethodCall = retrieved.get(0);
        NodeList arguments = addMethodCall.getArguments();
        this.commonVerifyMiningFieldsObjectCreation((List<Expression>)arguments, miningFields);
        retrieved = this.getMethodCallExprList(this.constructorDeclaration.getBody(), outputFields.size(), "outputFields", "add");
        addMethodCall = retrieved.get(0);
        arguments = addMethodCall.getArguments();
        this.commonVerifyOutputFieldsObjectCreation((List<Expression>)arguments, outputFields);
        retrieved = this.getMethodCallExprList(this.constructorDeclaration.getBody(), outputFields.size(), "kiePMMLTargets", "add");
        addMethodCall = retrieved.get(0);
        arguments = addMethodCall.getArguments();
        this.commonVerifyKiePMMLTargetFieldsMethodCallExpr((List<Expression>)arguments, targetFields);
    }

    @Test
    public void addGetCreatedKiePMMLMiningFieldsMethod() throws IOException {
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmmlModel, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        ClassOrInterfaceDeclaration modelTemplate = new ClassOrInterfaceDeclaration();
        KiePMMLModelFactoryUtils.addGetCreatedKiePMMLMiningFieldsMethod((ClassOrInterfaceDeclaration)modelTemplate, (List)compilationDTO.getMiningSchema().getMiningFields(), (List)compilationDTO.getFields());
        MethodDeclaration retrieved = (MethodDeclaration)modelTemplate.getMethodsByName("getCreatedKiePMMLMiningFields").get(0);
        String text = FileUtils.getFileContent((String)TEST_12_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)((Node)retrieved.getBody().get()))).isTrue();
    }

    @Test
    public void populateGetCreatedMiningFieldsMethod() throws IOException {
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmmlModel, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLModelFactoryUtils.populateGetCreatedMiningFieldsMethod((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (List)compilationDTO.getKieMiningFields());
        MethodDeclaration retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("getCreatedMiningFields").get(0);
        String text = FileUtils.getFileContent((String)TEST_14_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
    }

    @Test
    public void populateGetCreatedOutputFieldsMethod() throws IOException {
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmmlModel, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLModelFactoryUtils.populateGetCreatedOutputFieldsMethod((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (List)compilationDTO.getKieOutputFields());
        MethodDeclaration retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("getCreatedOutputFields").get(0);
        String text = FileUtils.getFileContent((String)TEST_13_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
    }

    @Test
    public void populateGetCreatedKiePMMLMiningFieldsMethod() throws IOException {
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmmlModel, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLModelFactoryUtils.populateGetCreatedKiePMMLMiningFieldsMethod((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (List)compilationDTO.getMiningSchema().getMiningFields(), (List)compilationDTO.getFields());
        MethodDeclaration retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("getCreatedKiePMMLMiningFields").get(0);
        String text = FileUtils.getFileContent((String)TEST_12_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)((Node)retrieved.getBody().get()))).isTrue();
    }

    @Test
    public void addGetCreatedKiePMMLOutputFieldsMethod() throws IOException {
        ClassOrInterfaceDeclaration modelTemplate = new ClassOrInterfaceDeclaration();
        KiePMMLModelFactoryUtils.addGetCreatedKiePMMLOutputFieldsMethod((ClassOrInterfaceDeclaration)modelTemplate, (List)model.getOutput().getOutputFields());
        MethodDeclaration retrieved = (MethodDeclaration)modelTemplate.getMethodsByName("getCreatedKiePMMLOutputFields").get(0);
        String text = FileUtils.getFileContent((String)TEST_11_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)((Node)retrieved.getBody().get()))).isTrue();
    }

    @Test
    public void populateGetCreatedKiePMMLOutputFieldsMethod() throws IOException {
        KiePMMLModelFactoryUtils.populateGetCreatedKiePMMLOutputFieldsMethod((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (List)model.getOutput().getOutputFields());
        MethodDeclaration retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("getCreatedKiePMMLOutputFields").get(0);
        String text = FileUtils.getFileContent((String)TEST_11_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)((Node)retrieved.getBody().get()))).isTrue();
    }

    @Test
    public void populateGetCreatedKiePMMLTargetsMethod() throws IOException {
        Random random = new Random();
        List kiePMMLTargets = IntStream.range(0, 3).mapToObj(i -> new TargetField(Collections.emptyList(), OP_TYPE.byName((String)PMMLModelTestUtils.getRandomOpType().value()), "Target-" + i, CAST_INTEGER.byName((String)PMMLModelTestUtils.getRandomCastInteger().value()), (Number)random.nextInt(20), (Number)((double)random.nextInt(60) + 20.0), (Number)((double)random.nextInt(100) / 100.0), (Number)((double)random.nextInt(100) / 100.0))).collect(Collectors.toList());
        String opType0 = OP_TYPE.class.getCanonicalName() + "." + ((TargetField)kiePMMLTargets.get(0)).getOpType().toString();
        String castInteger0 = CAST_INTEGER.class.getCanonicalName() + "." + ((TargetField)kiePMMLTargets.get(0)).getCastInteger().toString();
        String opType1 = OP_TYPE.class.getCanonicalName() + "." + ((TargetField)kiePMMLTargets.get(1)).getOpType().toString();
        String castInteger1 = CAST_INTEGER.class.getCanonicalName() + "." + ((TargetField)kiePMMLTargets.get(1)).getCastInteger().toString();
        String opType2 = OP_TYPE.class.getCanonicalName() + "." + ((TargetField)kiePMMLTargets.get(2)).getOpType().toString();
        String castInteger2 = CAST_INTEGER.class.getCanonicalName() + "." + ((TargetField)kiePMMLTargets.get(2)).getCastInteger().toString();
        KiePMMLModelFactoryUtils.populateGetCreatedKiePMMLTargetsMethod((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, kiePMMLTargets);
        MethodDeclaration retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("getCreatedKiePMMLTargets").get(0);
        String text = FileUtils.getFileContent((String)TEST_10_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)String.format(text, ((TargetField)kiePMMLTargets.get(0)).getName(), opType0, castInteger0, ((TargetField)kiePMMLTargets.get(0)).getMin(), ((TargetField)kiePMMLTargets.get(0)).getMax(), ((TargetField)kiePMMLTargets.get(0)).getRescaleConstant(), ((TargetField)kiePMMLTargets.get(0)).getRescaleFactor(), ((TargetField)kiePMMLTargets.get(1)).getName(), opType1, castInteger1, ((TargetField)kiePMMLTargets.get(1)).getMin(), ((TargetField)kiePMMLTargets.get(1)).getMax(), ((TargetField)kiePMMLTargets.get(1)).getRescaleConstant(), ((TargetField)kiePMMLTargets.get(1)).getRescaleFactor(), ((TargetField)kiePMMLTargets.get(2)).getName(), opType2, castInteger2, ((TargetField)kiePMMLTargets.get(2)).getMin(), ((TargetField)kiePMMLTargets.get(2)).getMax(), ((TargetField)kiePMMLTargets.get(2)).getRescaleConstant(), ((TargetField)kiePMMLTargets.get(2)).getRescaleFactor()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
    }

    @Test
    public void populateGetCreatedTransformationDictionaryMethod() throws IOException {
        KiePMMLModelFactoryUtils.populateGetCreatedTransformationDictionaryMethod((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (TransformationDictionary)pmmlModel.getTransformationDictionary());
        MethodDeclaration retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("getCreatedTransformationDictionary").get(0);
        String text = FileUtils.getFileContent((String)TEST_09_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
    }

    @Test
    public void populateGetCreatedLocalTransformationsMethod() throws IOException {
        KiePMMLModelFactoryUtils.populateGetCreatedLocalTransformationsMethod((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (LocalTransformations)model.getLocalTransformations());
        MethodDeclaration retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("getCreatedLocalTransformations").get(0);
        String text = FileUtils.getFileContent((String)TEST_08_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
    }

    @Test
    public void addTransformationsInClassOrInterfaceDeclaration() throws IOException {
        Assertions.assertThat((List)this.classOrInterfaceDeclaration.getMethodsByName("createTransformationDictionary")).isEmpty();
        Assertions.assertThat((List)this.classOrInterfaceDeclaration.getMethodsByName("createLocalTransformations")).isEmpty();
        KiePMMLModelFactoryUtils.addTransformationsInClassOrInterfaceDeclaration((ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration, (TransformationDictionary)pmmlModel.getTransformationDictionary(), (LocalTransformations)model.getLocalTransformations());
        Assertions.assertThat((List)this.classOrInterfaceDeclaration.getMethodsByName("createTransformationDictionary")).hasSize(1);
        Assertions.assertThat((List)this.classOrInterfaceDeclaration.getMethodsByName("createLocalTransformations")).hasSize(1);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)text);
        MethodDeclaration retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("createTransformationDictionary").get(0);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        text = FileUtils.getFileContent((String)TEST_02_SOURCE);
        expected = JavaParserUtils.parseMethod((String)text);
        retrieved = (MethodDeclaration)this.classOrInterfaceDeclaration.getMethodsByName("createLocalTransformations").get(0);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
    }

    @Test
    public void init() throws IOException {
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmmlModel, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLModelFactoryUtils.init((CompilationDTO)compilationDTO, (ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration);
        BlockStmt body = this.constructorDeclaration.getBody();
        String text = FileUtils.getFileContent((String)TEST_03_SOURCE);
        BlockStmt expected = JavaParserUtils.parseConstructorBlock((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)body)).isTrue();
    }

    @Test
    public void initStaticGetter() throws IOException {
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmmlModel, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLModelFactoryUtils.initStaticGetter((CompilationDTO)compilationDTO, (ClassOrInterfaceDeclaration)this.classOrInterfaceDeclaration);
        String text = FileUtils.getFileContent((String)TEST_04_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)text);
        Assertions.assertThat((String)this.staticGetterMethod.toString()).isEqualTo(expected.toString());
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)this.staticGetterMethod)).isTrue();
    }

    @Test
    public void getMiningFieldsObjectCreations() {
        List<MiningField> miningFields = IntStream.range(0, 3).mapToObj(i -> ModelUtils.convertToKieMiningField((org.dmg.pmml.MiningField)PMMLModelTestUtils.getRandomMiningField(), (Field)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List retrieved = KiePMMLModelFactoryUtils.getMiningFieldsObjectCreations(miningFields);
        this.commonVerifyMiningFieldsObjectCreation(retrieved, miningFields);
    }

    @Test
    public void createIntervalsExpression() {
        List intervals = IntStream.range(0, 3).mapToObj(i -> {
            int leftMargin = new Random().nextInt(40);
            int rightMargin = leftMargin + 13;
            return new Interval((Number)leftMargin, (Number)rightMargin);
        }).collect(Collectors.toList());
        Expression retrieved = KiePMMLModelFactoryUtils.createIntervalsExpression(intervals);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isInstanceOf(MethodCallExpr.class);
        MethodCallExpr mtdExp = (MethodCallExpr)retrieved;
        String expected = "java.util.Arrays";
        Assertions.assertThat((String)((Expression)mtdExp.getScope().get()).asNameExpr().toString()).isEqualTo(expected);
        expected = "asList";
        Assertions.assertThat((String)mtdExp.getName().asString()).isEqualTo(expected);
        NodeList arguments = mtdExp.getArguments();
        Assertions.assertThat((List)arguments).hasSameSizeAs(intervals);
        arguments.forEach(argument -> {
            Assertions.assertThat((Object)argument).isInstanceOf(ObjectCreationExpr.class);
            ObjectCreationExpr objCrt = (ObjectCreationExpr)argument;
            Assertions.assertThat((String)objCrt.getType().asString()).isEqualTo(Interval.class.getCanonicalName());
            Optional<Interval> intervalOpt = intervals.stream().filter(interval -> String.valueOf(interval.getLeftMargin()).equals(objCrt.getArgument(0).asNameExpr().toString()) && String.valueOf(interval.getRightMargin()).equals(objCrt.getArgument(1).asNameExpr().toString())).findFirst();
            Assertions.assertThat(intervalOpt).isPresent();
        });
    }

    @Test
    public void getObjectCreationExprFromInterval() {
        Interval interval = new Interval(null, (Number)-14);
        ObjectCreationExpr retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getType().asString()).isEqualTo(Interval.class.getCanonicalName());
        NodeList arguments = retrieved.getArguments();
        Assertions.assertThat((List)arguments).hasSize(2);
        Assertions.assertThat((Object)((Expression)arguments.get(0))).isInstanceOf(NullLiteralExpr.class);
        Assertions.assertThat((String)((Expression)arguments.get(1)).asNameExpr().toString()).isEqualTo(String.valueOf(interval.getRightMargin()));
        interval = new Interval((Number)-13, (Number)10);
        retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getType().asString()).isEqualTo(Interval.class.getCanonicalName());
        arguments = retrieved.getArguments();
        Assertions.assertThat((List)arguments).hasSize(2);
        Assertions.assertThat((String)((Expression)arguments.get(0)).asNameExpr().toString()).isEqualTo(String.valueOf(interval.getLeftMargin()));
        Assertions.assertThat((String)((Expression)arguments.get(1)).asNameExpr().toString()).isEqualTo(String.valueOf(interval.getRightMargin()));
        interval = new Interval((Number)-13, null);
        retrieved = KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval((Interval)interval);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((String)retrieved.getType().asString()).isEqualTo(Interval.class.getCanonicalName());
        arguments = retrieved.getArguments();
        Assertions.assertThat((List)arguments).hasSize(2);
        Assertions.assertThat((String)((Expression)arguments.get(0)).asNameExpr().toString()).isEqualTo(String.valueOf(interval.getLeftMargin()));
        Assertions.assertThat((Object)((Expression)arguments.get(1))).isInstanceOf(NullLiteralExpr.class);
    }

    @Test
    public void getOutputFieldsObjectCreations() {
        List<OutputField> outputFields = IntStream.range(0, 2).mapToObj(i -> ModelUtils.convertToKieOutputField((org.dmg.pmml.OutputField)PMMLModelTestUtils.getRandomOutputField(), (Field)PMMLModelTestUtils.getRandomDataField())).collect(Collectors.toList());
        List retrieved = KiePMMLModelFactoryUtils.getOutputFieldsObjectCreations(outputFields);
        this.commonVerifyOutputFieldsObjectCreation(retrieved, outputFields);
    }

    @Test
    public void populateTransformationsInConstructor() throws IOException {
        String createTransformationDictionary = "createTransformationDictionary";
        String createLocalTransformations = "createLocalTransformations";
        KiePMMLModelFactoryUtils.populateTransformationsInConstructor((ConstructorDeclaration)this.constructorDeclaration, (String)"createTransformationDictionary", (String)"createLocalTransformations");
        String text = FileUtils.getFileContent((String)TEST_07_SOURCE);
        BlockStmt expected = JavaParserUtils.parseConstructorBlock((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)this.constructorDeclaration.getBody())).isTrue();
    }

    @Test
    public void commonPopulateGetCreatedKiePMMLMiningFieldsMethod() throws IOException {
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmmlModel, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        MethodDeclaration methodDeclaration = new MethodDeclaration();
        KiePMMLModelFactoryUtils.commonPopulateGetCreatedKiePMMLMiningFieldsMethod((MethodDeclaration)methodDeclaration, (List)compilationDTO.getMiningSchema().getMiningFields(), (List)compilationDTO.getFields());
        String text = FileUtils.getFileContent((String)TEST_06_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)methodDeclaration)).isTrue();
    }

    @Test
    public void commonPopulateGetCreatedKiePMMLOutputFieldsMethod() throws IOException {
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmmlModel, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        MethodDeclaration methodDeclaration = new MethodDeclaration();
        KiePMMLModelFactoryUtils.commonPopulateGetCreatedKiePMMLOutputFieldsMethod((MethodDeclaration)methodDeclaration, (List)compilationDTO.getOutput().getOutputFields());
        String text = FileUtils.getFileContent((String)TEST_05_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)methodDeclaration)).isTrue();
    }

    private void commonVerifyMiningFieldsObjectCreation(List<Expression> toVerify, List<MiningField> miningFields) {
        toVerify.forEach(expression -> {
            Assertions.assertThat((Object)expression).isInstanceOf(ObjectCreationExpr.class);
            ObjectCreationExpr objCrt = (ObjectCreationExpr)expression;
            Assertions.assertThat((String)objCrt.getType().asString()).isEqualTo(MiningField.class.getCanonicalName());
            Optional<MiningField> miningFieldOpt = miningFields.stream().filter(miningField -> miningField.getName().equals(objCrt.getArgument(0).asStringLiteralExpr().asString())).findFirst();
            Assertions.assertThat(miningFieldOpt).isPresent();
            MiningField miningField2 = miningFieldOpt.get();
            Assertions.assertThat((String)objCrt.getType().asString()).isEqualTo(MiningField.class.getCanonicalName());
            String expected = miningField2.getUsageType() != null ? FIELD_USAGE_TYPE.class.getCanonicalName() + "." + miningField2.getUsageType() : "null";
            Assertions.assertThat((String)objCrt.getArgument(1).toString()).isEqualTo(expected);
            expected = miningField2.getOpType() != null ? OP_TYPE.class.getCanonicalName() + "." + miningField2.getOpType() : "null";
            Assertions.assertThat((String)objCrt.getArgument(2).toString()).isEqualTo(expected);
            expected = miningField2.getDataType() != null ? DATA_TYPE.class.getCanonicalName() + "." + miningField2.getDataType() : "null";
            Assertions.assertThat((String)objCrt.getArgument(3).toString()).isEqualTo(expected);
            expected = miningField2.getMissingValueTreatmentMethod() != null ? MISSING_VALUE_TREATMENT_METHOD.class.getCanonicalName() + "." + miningField2.getMissingValueTreatmentMethod() : "null";
            Assertions.assertThat((String)objCrt.getArgument(4).toString()).isEqualTo(expected);
            expected = miningField2.getInvalidValueTreatmentMethod() != null ? INVALID_VALUE_TREATMENT_METHOD.class.getCanonicalName() + "." + miningField2.getInvalidValueTreatmentMethod() : "null";
            Assertions.assertThat((String)objCrt.getArgument(5).toString()).isEqualTo(expected);
            expected = miningField2.getMissingValueReplacement() != null ? miningField2.getMissingValueReplacement() : "null";
            Assertions.assertThat((String)objCrt.getArgument(6).asStringLiteralExpr().asString()).isEqualTo(expected);
            expected = miningField2.getInvalidValueReplacement() != null ? miningField2.getInvalidValueReplacement() : "null";
            Assertions.assertThat((String)objCrt.getArgument(7).asStringLiteralExpr().asString()).isEqualTo(expected);
            MethodCallExpr allowedValuesMethod = objCrt.getArgument(8).asMethodCallExpr();
            IntStream.range(0, 3).forEach(i -> {
                String exp = (String)miningField2.getAllowedValues().get(i);
                Assertions.assertThat((String)allowedValuesMethod.getArgument(i).asStringLiteralExpr().asString()).isEqualTo(exp);
            });
            MethodCallExpr intervalsMethod = objCrt.getArgument(9).asMethodCallExpr();
            IntStream.range(0, 3).forEach(i -> {
                Interval interval = (Interval)miningField2.getIntervals().get(i);
                ObjectCreationExpr objectCreationExpr = intervalsMethod.getArgument(i).asObjectCreationExpr();
                String exp = interval.getLeftMargin().toString();
                Assertions.assertThat((String)objectCreationExpr.getArgument(0).asNameExpr().toString()).isEqualTo(exp);
                exp = interval.getRightMargin().toString();
                Assertions.assertThat((String)objectCreationExpr.getArgument(1).asNameExpr().toString()).isEqualTo(exp);
            });
        });
    }

    private void commonVerifyOutputFieldsObjectCreation(List<Expression> toVerify, List<OutputField> outputFields) {
        toVerify.forEach(argument -> {
            Assertions.assertThat((Object)argument).isInstanceOf(ObjectCreationExpr.class);
            ObjectCreationExpr objCrt = (ObjectCreationExpr)argument;
            Assertions.assertThat((String)objCrt.getType().asString()).isEqualTo(OutputField.class.getCanonicalName());
            Optional<OutputField> outputFieldOpt = outputFields.stream().filter(outputField -> outputField.getName().equals(objCrt.getArgument(0).asStringLiteralExpr().asString())).findFirst();
            Assertions.assertThat(outputFieldOpt).isPresent();
            OutputField outputField2 = outputFieldOpt.get();
            String expected = OP_TYPE.class.getCanonicalName() + "." + outputField2.getOpType();
            Assertions.assertThat((String)objCrt.getArgument(1).asNameExpr().toString()).isEqualTo(expected);
            expected = DATA_TYPE.class.getCanonicalName() + "." + outputField2.getDataType();
            Assertions.assertThat((String)objCrt.getArgument(2).asNameExpr().toString()).isEqualTo(expected);
            expected = outputField2.getTargetField();
            Assertions.assertThat((String)objCrt.getArgument(3).asStringLiteralExpr().asString()).isEqualTo(expected);
            expected = RESULT_FEATURE.class.getCanonicalName() + "." + outputField2.getResultFeature();
            Assertions.assertThat((String)objCrt.getArgument(4).asNameExpr().toString()).isEqualTo(expected);
            MethodCallExpr allowedValuesMethod = objCrt.getArgument(5).asMethodCallExpr();
            IntStream.range(0, 3).forEach(i -> {
                String exp = (String)outputField2.getAllowedValues().get(i);
                Assertions.assertThat((String)allowedValuesMethod.getArgument(i).asStringLiteralExpr().asString()).isEqualTo(exp);
            });
        });
    }

    private void commonVerifyKiePMMLTargetFieldsMethodCallExpr(List<Expression> toVerify, List<TargetField> targetFields) {
        toVerify.forEach(argument -> {
            Assertions.assertThat((Object)argument).isInstanceOf(MethodCallExpr.class);
            MethodCallExpr mtdfClExpr = (MethodCallExpr)argument;
            Assertions.assertThat((String)mtdfClExpr.getName().asString()).isEqualTo("build");
            MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom((String)"builder", (MethodCallExpr)mtdfClExpr);
            Optional<TargetField> targetFieldOpt = targetFields.stream().filter(targetField -> targetField.getName().equals(builder.getArgument(0).asStringLiteralExpr().asString())).findFirst();
            Assertions.assertThat(targetFieldOpt).isPresent();
            TargetField targetField2 = targetFieldOpt.get();
            try {
                this.commonVerifyKiePMMLTargetFieldsMethodCallExpr(mtdfClExpr, targetField2);
            }
            catch (IOException e) {
                Assertions.fail((String)e.getMessage());
            }
        });
    }

    private void commonVerifyKiePMMLTargetFieldsMethodCallExpr(MethodCallExpr retrieved, TargetField kieTargetField) throws IOException {
        String text = FileUtils.getFileContent((String)TEST_15_SOURCE);
        List kieTargetValues = kieTargetField.getTargetValues();
        String opType = OP_TYPE.class.getCanonicalName() + "." + kieTargetField.getOpType().toString();
        String castInteger = CAST_INTEGER.class.getCanonicalName() + "." + kieTargetField.getCastInteger().toString();
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, kieTargetField.getName(), ((TargetValue)kieTargetValues.get(0)).getValue(), ((TargetValue)kieTargetValues.get(0)).getDisplayValue(), ((TargetValue)kieTargetValues.get(0)).getPriorProbability(), ((TargetValue)kieTargetValues.get(0)).getDefaultValue(), ((TargetValue)kieTargetValues.get(1)).getValue(), ((TargetValue)kieTargetValues.get(1)).getDisplayValue(), ((TargetValue)kieTargetValues.get(1)).getPriorProbability(), ((TargetValue)kieTargetValues.get(1)).getDefaultValue(), ((TargetValue)kieTargetValues.get(2)).getValue(), ((TargetValue)kieTargetValues.get(2)).getDisplayValue(), ((TargetValue)kieTargetValues.get(2)).getPriorProbability(), ((TargetValue)kieTargetValues.get(2)).getDefaultValue(), opType, kieTargetField.getField(), castInteger, kieTargetField.getMin(), kieTargetField.getMax(), kieTargetField.getRescaleConstant(), kieTargetField.getRescaleFactor()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLTarget.class, KiePMMLTargetValue.class, TargetField.class, TargetValue.class);
        CodegenTestUtils.commonValidateCompilationWithImports((Expression)retrieved, imports);
    }

    private void commonVerifySuperInvocation(String generatedClassName, String name) {
        Assertions.assertThat((String)this.constructorDeclaration.getName().asString()).isEqualTo(generatedClassName);
        String expected = String.format("super(\"%s\", Collections.emptyList(), operator, second);", name);
        Assertions.assertThat((String)this.superInvocation.toString()).isEqualTo(expected);
    }

    private List<MethodCallExpr> getMethodCallExprList(BlockStmt blockStmt, int expectedSize, String scope, String method) {
        Stream<Statement> statementStream = this.getStatementStream(blockStmt);
        List<MethodCallExpr> toReturn = statementStream.filter(Statement::isExpressionStmt).map(expressionStmt -> ((ExpressionStmt)expressionStmt).getExpression()).filter(expression -> expression instanceof MethodCallExpr).map(expression -> (MethodCallExpr)expression).filter(methodCallExpr -> this.evaluateMethodCallExpr((MethodCallExpr)methodCallExpr, scope, method)).collect(Collectors.toList());
        Assertions.assertThat(toReturn).hasSize(expectedSize);
        return toReturn;
    }

    private boolean evaluateMethodCallExpr(MethodCallExpr methodCallExpr, String scope, String method) {
        return methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).isNameExpr() && ((NameExpr)methodCallExpr.getScope().get()).getName().asString().equals(scope) && methodCallExpr.getName().asString().equals(method);
    }

    private Stream<Statement> getStatementStream(BlockStmt blockStmt) {
        NodeList statements = blockStmt.getStatements();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(statements.iterator(), 16), false);
    }
}

