/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NormDiscrete;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLNormDiscrete;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLNormDiscreteFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLNormDiscreteFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLNormDiscreteFactoryTest_01.txt";

    @Test
    public void getNormDiscreteVariableDeclaration() throws IOException {
        String variableName = "variableName";
        String fieldName = "fieldName";
        String fieldValue = "fieldValue";
        double mapMissingTo = 45.32;
        NormDiscrete normDiscrete = new NormDiscrete();
        normDiscrete.setField(FieldName.create((String)fieldName));
        normDiscrete.setValue((Object)fieldValue);
        normDiscrete.setMapMissingTo((Number)mapMissingTo);
        BlockStmt retrieved = KiePMMLNormDiscreteFactory.getNormDiscreteVariableDeclaration((String)variableName, (NormDiscrete)normDiscrete);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, variableName, fieldName, fieldValue, mapMissingTo));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(Collections.class, KiePMMLNormDiscrete.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

