/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.junit.Test;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLParameterFieldFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLParameterFieldFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLParameterFieldFactoryTest_01.txt";

    @Test
    public void getParameterFieldVariableDeclaration() throws IOException {
        String variableName = "variableName";
        ParameterField parameterField = new ParameterField(FieldName.create((String)variableName));
        parameterField.setDataType(DataType.DOUBLE);
        parameterField.setOpType(OpType.CONTINUOUS);
        parameterField.setDisplayName("displayName");
        String dataType = CommonTestingUtils.getDATA_TYPEString((DataType)parameterField.getDataType());
        String opType = CommonTestingUtils.getOP_TYPEString((OpType)parameterField.getOpType());
        BlockStmt retrieved = KiePMMLParameterFieldFactory.getParameterFieldVariableDeclaration((String)variableName, (ParameterField)parameterField);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, variableName, dataType, opType, parameterField.getDisplayName()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLParameterField.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

