/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.TransformationDictionary;
import org.junit.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;
import org.kie.pmml.commons.transformations.KiePMMLTransformationDictionary;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTransformationDictionaryFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLTransformationDictionaryFactoryTest {
    private static final String CUSTOM_FUNCTION = "CUSTOM_FUNCTION";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;
    private static final String TEST_01_SOURCE = "KiePMMLTransformationDictionaryFactoryTest_01.txt";

    @Test
    public void getKiePMMLTransformationDictionaryVariableDeclaration() throws IOException {
        TransformationDictionary transformationDictionary = new TransformationDictionary();
        transformationDictionary.addDefineFunctions(this.getDefineFunctions());
        transformationDictionary.addDerivedFields(this.getDerivedFields());
        BlockStmt retrieved = KiePMMLTransformationDictionaryFactory.getKiePMMLTransformationDictionaryVariableDeclaration((TransformationDictionary)transformationDictionary);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLParameterField.class, KiePMMLConstant.class, KiePMMLFieldRef.class, KiePMMLApply.class, KiePMMLDerivedField.class, KiePMMLDefineFunction.class, KiePMMLTransformationDictionary.class, Arrays.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    private DefineFunction[] getDefineFunctions() {
        return (DefineFunction[])IntStream.range(0, 2).mapToObj(this::getDefineFunction).toArray(DefineFunction[]::new);
    }

    private DefineFunction getDefineFunction(int counter) {
        ParameterField parameterField1 = new ParameterField(FieldName.create((String)(PARAM_1 + counter)));
        parameterField1.setDataType(DataType.DOUBLE);
        parameterField1.setOpType(OpType.CONTINUOUS);
        parameterField1.setDisplayName("displayName1" + counter);
        ParameterField parameterField2 = new ParameterField(FieldName.create((String)(PARAM_2 + counter)));
        parameterField2.setDataType(DataType.DOUBLE);
        parameterField2.setOpType(OpType.CONTINUOUS);
        parameterField2.setDisplayName("displayName2" + counter);
        Constant constant = new Constant();
        constant.setValue((Object)value1);
        FieldRef fieldRef = new FieldRef();
        fieldRef.setField(FieldName.create((String)("FIELD_REF" + counter)));
        Apply apply = new Apply();
        apply.setFunction("/");
        apply.addExpressions(new Expression[]{constant, fieldRef});
        DefineFunction toReturn = new DefineFunction();
        toReturn.setName(CUSTOM_FUNCTION + counter);
        toReturn.addParameterFields(new ParameterField[]{parameterField1, parameterField2});
        toReturn.setDataType(DataType.DOUBLE);
        toReturn.setOpType(OpType.CONTINUOUS);
        toReturn.setExpression((Expression)apply);
        return toReturn;
    }

    private DerivedField[] getDerivedFields() {
        return (DerivedField[])IntStream.range(0, 2).mapToObj(this::getDerivedField).toArray(DerivedField[]::new);
    }

    private DerivedField getDerivedField(int counter) {
        Constant constant = new Constant();
        constant.setValue((Object)value1);
        DerivedField toReturn = new DerivedField();
        toReturn.setName(FieldName.create((String)(PARAM_2 + counter)));
        toReturn.setDataType(DataType.DOUBLE);
        toReturn.setOpType(OpType.CONTINUOUS);
        toReturn.setExpression((Expression)constant);
        return toReturn;
    }
}

