/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.TargetValue;
import org.junit.Test;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.codegenfactories.TargetValueFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class TargetValueFactoryTest {
    private static final String TEST_01_SOURCE = "TargetValueFactoryTest_01.txt";

    @Test
    public void getTargetValueVariableInitializer() throws IOException {
        org.kie.pmml.api.models.TargetValue targetValue = ModelUtils.convertToKieTargetValue((TargetValue)PMMLModelTestUtils.getRandomTargetValue());
        ObjectCreationExpr retrieved = TargetValueFactory.getTargetValueVariableInitializer((org.kie.pmml.api.models.TargetValue)targetValue);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, targetValue.getValue(), targetValue.getDisplayValue(), targetValue.getPriorProbability(), targetValue.getDefaultValue()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLTargetValue.class, org.kie.pmml.api.models.TargetValue.class);
        CodegenTestUtils.commonValidateCompilationWithImports((Expression)retrieved, imports);
    }
}

