/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.pmml.compiler.commons.factories.KiePMMLFactoryFactory;

public class KiePMMLFactoryFactoryTest {
    @Test
    public void getInstantiationExpression() {
        String kiePMMLModelClass = "org.kie.model.ClassModel";
        Expression retrieved = KiePMMLFactoryFactory.getInstantiationExpression((String)"org.kie.model.ClassModel", (boolean)true);
        this.validateNotCodegen(retrieved, "org.kie.model.ClassModel");
        retrieved = KiePMMLFactoryFactory.getInstantiationExpression((String)"org.kie.model.ClassModel", (boolean)false);
        this.validateCodegen(retrieved, "org.kie.model.ClassModel");
    }

    private void validateNotCodegen(Expression toValidate, String kiePMMLModelClass) {
        Assertions.assertThat((Object)toValidate).isNotNull();
        Assertions.assertThat((Object)toValidate).isInstanceOf(MethodCallExpr.class);
        MethodCallExpr methodCallExpr = (MethodCallExpr)toValidate;
        Assertions.assertThat((String)((Expression)methodCallExpr.getScope().get()).asNameExpr().toString()).isEqualTo(kiePMMLModelClass);
        Assertions.assertThat((String)methodCallExpr.getName().asString()).isEqualTo("getModel");
    }

    private void validateCodegen(Expression toValidate, String kiePMMLModelClass) {
        Assertions.assertThat((Object)toValidate).isNotNull();
        Assertions.assertThat((Object)toValidate).isInstanceOf(ObjectCreationExpr.class);
        ObjectCreationExpr objectCreationExpr = (ObjectCreationExpr)toValidate;
        Assertions.assertThat((String)objectCreationExpr.getType().asString()).isEqualTo(kiePMMLModelClass);
    }
}

