/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.Name;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class JavaParserUtilsTest {
    private static final String TEMPLATE_FILE = "Template.tmpl";
    private static final String TEMPLATE_CLASS = "Template";
    private static final String NOT_PARSABLE_FILE = "Unparsable.tmpl";

    @Test
    public void getFromFileName() {
        CompilationUnit retrieved = JavaParserUtils.getFromFileName((String)TEMPLATE_FILE);
        Assertions.assertThat((Object)retrieved).isNotNull();
    }

    @Test(expected=KiePMMLInternalException.class)
    public void getFromFileNameNotParsable() {
        JavaParserUtils.getFromFileName((String)NOT_PARSABLE_FILE);
    }

    @Test(expected=AssertionError.class)
    public void getFromFileNameNotExisting() {
        JavaParserUtils.getFromFileName((String)"not_existing");
    }

    @Test
    public void getKiePMMLModelCompilationUnitWithPackage() {
        String className = "ClassName";
        String packageName = "apackage";
        CompilationUnit retrieved = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)TEMPLATE_FILE, (String)TEMPLATE_CLASS);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Optional)retrieved.getPackageDeclaration()).isPresent();
        Assertions.assertThat((String)((PackageDeclaration)retrieved.getPackageDeclaration().get()).getName().asString()).isEqualTo(packageName);
        Assertions.assertThat((Optional)retrieved.getClassByName(TEMPLATE_CLASS)).isNotPresent();
        Assertions.assertThat((Optional)retrieved.getClassByName(className)).isPresent();
    }

    @Test
    public void getKiePMMLModelCompilationUnitWithoutPackage() {
        String className = "ClassName";
        CompilationUnit retrieved = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, null, (String)TEMPLATE_FILE, (String)TEMPLATE_CLASS);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Optional)retrieved.getPackageDeclaration()).isNotPresent();
        Assertions.assertThat((Optional)retrieved.getClassByName(TEMPLATE_CLASS)).isNotPresent();
        Assertions.assertThat((Optional)retrieved.getClassByName(className)).isPresent();
    }

    @Test
    public void getFullClassName() {
        String className = "ClassName";
        String packageName = "apackage";
        PackageDeclaration packageDeclaration = new PackageDeclaration();
        packageDeclaration.setName(new Name(packageName));
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration();
        classOrInterfaceDeclaration.setName(className);
        CompilationUnit compilationUnit = new CompilationUnit();
        compilationUnit.setPackageDeclaration(packageDeclaration);
        compilationUnit.setTypes(NodeList.nodeList((Node[])new TypeDeclaration[]{classOrInterfaceDeclaration}));
        String retrieved = JavaParserUtils.getFullClassName((CompilationUnit)compilationUnit);
        String expected = packageName + "." + className;
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }
}

