/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.drools.util.FileUtils;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLApplyFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLApplyFactoryTest {
    private static final String function = "function";
    private static final Double value1 = 100.0;
    private static final Double value2 = 5.0;
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final String TEST_01_SOURCE = "KiePMMLApplyFactoryTest_01.txt";
    private static final String TEST_02_SOURCE = "KiePMMLApplyFactoryTest_02.txt";
    private static final String TEST_03_SOURCE = "KiePMMLApplyFactoryTest_03.txt";

    @Test
    void getApplyVariableDeclarationWithConstants() throws IOException {
        String variableName = "variableName";
        Apply apply = new Apply();
        apply.setFunction(function);
        String mapMissingTo = "mapMissingTo";
        apply.setMapMissingTo(mapMissingTo);
        String defaultValue = "defaultValue";
        apply.setDefaultValue(defaultValue);
        InvalidValueTreatmentMethod invalidValueTreatmentMethod = InvalidValueTreatmentMethod.AS_MISSING;
        apply.setInvalidValueTreatment(invalidValueTreatmentMethod);
        Constant constant1 = new Constant();
        constant1.setValue((Object)value1);
        Constant constant2 = new Constant();
        constant2.setValue((Object)value2);
        apply.addExpressions(new Expression[]{constant1, constant2});
        BlockStmt retrieved = KiePMMLApplyFactory.getApplyVariableDeclaration((String)variableName, (Apply)apply);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, value1, value2, variableName, function, defaultValue, mapMissingTo, invalidValueTreatmentMethod.value()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLConstant.class, KiePMMLApply.class, Collections.class, Arrays.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    @Test
    void getApplyVariableDeclarationWithFieldRefs() throws IOException {
        String variableName = "variableName";
        Apply apply = new Apply();
        apply.setFunction(function);
        String mapMissingTo = "mapMissingTo";
        apply.setMapMissingTo(mapMissingTo);
        String defaultValue = "defaultValue";
        apply.setDefaultValue(defaultValue);
        InvalidValueTreatmentMethod invalidValueTreatmentMethod = InvalidValueTreatmentMethod.AS_MISSING;
        apply.setInvalidValueTreatment(invalidValueTreatmentMethod);
        FieldRef fieldRef1 = new FieldRef();
        fieldRef1.setField(FieldName.create((String)PARAM_1));
        FieldRef fieldRef2 = new FieldRef();
        fieldRef2.setField(FieldName.create((String)PARAM_2));
        apply.addExpressions(new Expression[]{fieldRef1, fieldRef2});
        BlockStmt retrieved = KiePMMLApplyFactory.getApplyVariableDeclaration((String)variableName, (Apply)apply);
        String text = FileUtils.getFileContent((String)TEST_02_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, PARAM_1, PARAM_2, variableName, function, defaultValue, mapMissingTo, invalidValueTreatmentMethod.value()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLFieldRef.class, KiePMMLApply.class, Collections.class, Arrays.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    @Test
    void getApplyVariableDeclarationWithApply() throws IOException {
        String variableName = "variableName";
        Apply nestedApply = new Apply();
        nestedApply.setFunction("nested_function");
        String mapMissingTo = "mapMissingTo";
        nestedApply.setMapMissingTo(mapMissingTo);
        String defaultValue = "defaultValue";
        nestedApply.setDefaultValue(defaultValue);
        InvalidValueTreatmentMethod nestedInvalidValueTreatmentMethod = InvalidValueTreatmentMethod.AS_MISSING;
        nestedApply.setInvalidValueTreatment(nestedInvalidValueTreatmentMethod);
        FieldRef fieldRef1 = new FieldRef();
        fieldRef1.setField(FieldName.create((String)PARAM_1));
        FieldRef fieldRef2 = new FieldRef();
        fieldRef2.setField(FieldName.create((String)PARAM_2));
        nestedApply.addExpressions(new Expression[]{fieldRef1, fieldRef2});
        Apply apply = new Apply();
        apply.setFunction(function);
        InvalidValueTreatmentMethod invalidValueTreatmentMethod = InvalidValueTreatmentMethod.AS_MISSING;
        apply.setInvalidValueTreatment(invalidValueTreatmentMethod);
        apply.addExpressions(new Expression[]{nestedApply});
        BlockStmt retrieved = KiePMMLApplyFactory.getApplyVariableDeclaration((String)variableName, (Apply)apply);
        String text = FileUtils.getFileContent((String)TEST_03_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, PARAM_1, PARAM_2, defaultValue, mapMissingTo, nestedInvalidValueTreatmentMethod.value(), variableName, invalidValueTreatmentMethod.value()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLFieldRef.class, KiePMMLApply.class, Collections.class, Arrays.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }
}

