/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.OpType;
import org.drools.util.FileUtils;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.commons.transformations.KiePMMLLocalTransformations;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLLocalTransformationsFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLLocalTransformationsFactoryTest {
    private static final String CUSTOM_FUNCTION = "CUSTOM_FUNCTION";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;
    private static final String TEST_01_SOURCE = "KiePMMLLocalTransformationsFactoryTest_01.txt";

    @Test
    void getKiePMMLTransformationDictionaryVariableDeclaration() throws IOException {
        LocalTransformations localTransformations = new LocalTransformations();
        localTransformations.addDerivedFields(this.getDerivedFields());
        BlockStmt retrieved = KiePMMLLocalTransformationsFactory.getKiePMMLLocalTransformationsVariableDeclaration((LocalTransformations)localTransformations);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)text);
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(KiePMMLConstant.class, KiePMMLApply.class, KiePMMLDerivedField.class, KiePMMLLocalTransformations.class, Arrays.class, Collections.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    private DerivedField[] getDerivedFields() {
        return (DerivedField[])IntStream.range(0, 2).mapToObj(this::getDerivedField).toArray(DerivedField[]::new);
    }

    private DerivedField getDerivedField(int counter) {
        Constant constant = new Constant();
        constant.setValue((Object)value1);
        DerivedField toReturn = new DerivedField();
        toReturn.setName(FieldName.create((String)(PARAM_2 + counter)));
        toReturn.setDataType(DataType.DOUBLE);
        toReturn.setOpType(OpType.CONTINUOUS);
        toReturn.setExpression((Expression)constant);
        return toReturn;
    }
}

