/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.drools.util.FileUtils;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.OUTLIER_TREATMENT_METHOD;
import org.kie.pmml.commons.model.expressions.KiePMMLLinearNorm;
import org.kie.pmml.commons.model.expressions.KiePMMLNormContinuous;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLNormContinuousFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLNormContinuousFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLNormContinuousFactoryTest_01.txt";
    private static final String TEST_02_SOURCE = "KiePMMLNormContinuousFactoryTest_02.txt";

    @Test
    void getNormContinuousVariableDeclaration() throws IOException {
        String variableName = "variableName";
        NormContinuous normContinuous = PMMLModelTestUtils.getRandomNormContinuous();
        List linearNorms = normContinuous.getLinearNorms();
        BlockStmt retrieved = KiePMMLNormContinuousFactory.getNormContinuousVariableDeclaration((String)variableName, (NormContinuous)normContinuous);
        String outlierString = OUTLIER_TREATMENT_METHOD.class.getName() + "." + OUTLIER_TREATMENT_METHOD.byName((String)normContinuous.getOutliers().value()).name();
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, variableName, normContinuous.getField().getValue(), ((LinearNorm)linearNorms.get(0)).getOrig(), ((LinearNorm)linearNorms.get(0)).getNorm(), ((LinearNorm)linearNorms.get(1)).getOrig(), ((LinearNorm)linearNorms.get(1)).getNorm(), ((LinearNorm)linearNorms.get(2)).getOrig(), ((LinearNorm)linearNorms.get(2)).getNorm(), outlierString, normContinuous.getMapMissingTo()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLLinearNorm.class, KiePMMLNormContinuous.class, OUTLIER_TREATMENT_METHOD.class);
        CodegenTestUtils.commonValidateCompilationWithImports(retrieved, imports);
    }

    @Test
    void getNewKiePMMLLinearNormExpression() throws IOException {
        String name = "name";
        LinearNorm linearNorm = PMMLModelTestUtils.getRandomLinearNorm();
        Expression retrieved = KiePMMLNormContinuousFactory.getNewKiePMMLLinearNormExpression((LinearNorm)linearNorm, (String)name);
        String text = FileUtils.getFileContent((String)TEST_02_SOURCE);
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, name, linearNorm.getOrig(), linearNorm.getNorm()));
        Assertions.assertThat((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved)).isTrue();
    }
}

