/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.text.StringEscapeUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Interval;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Row;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.True;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLMiningField;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretize;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretizeBin;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldColumnPair;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.model.expressions.KiePMMLInlineTable;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;
import org.kie.pmml.commons.model.expressions.KiePMMLLinearNorm;
import org.kie.pmml.commons.model.expressions.KiePMMLMapValues;
import org.kie.pmml.commons.model.expressions.KiePMMLNormContinuous;
import org.kie.pmml.commons.model.expressions.KiePMMLNormDiscrete;
import org.kie.pmml.commons.model.expressions.KiePMMLRow;
import org.kie.pmml.commons.model.expressions.KiePMMLTextIndex;
import org.kie.pmml.commons.model.expressions.KiePMMLTextIndexNormalization;
import org.kie.pmml.commons.model.predicates.KiePMMLCompoundPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLFalsePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimplePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLTruePredicate;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;

public class InstanceFactoriesTestCommon {
    static void commonVerifyKiePMMLDefineFunction(KiePMMLDefineFunction toVerify, DefineFunction source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getName());
        DATA_TYPE expectedDataType = DATA_TYPE.byName((String)source.getDataType().value());
        Assertions.assertThat((Comparable)toVerify.getDataType()).isEqualTo((Object)expectedDataType);
        OP_TYPE expectedOpType = OP_TYPE.byName((String)source.getOpType().value());
        Assertions.assertThat((Comparable)toVerify.getOpType()).isEqualTo((Object)expectedOpType);
        InstanceFactoriesTestCommon.commonVerifyKiePMMLExpression(toVerify.getKiePMMLExpression(), source.getExpression());
        List sourcesParameterFields = source.getParameterFields();
        List toVerifyList = toVerify.getParameterFields();
        Assertions.assertThat((List)toVerifyList).hasSameSizeAs((Iterable)sourcesParameterFields);
        sourcesParameterFields.forEach(paramSource -> {
            Optional<KiePMMLParameterField> parameterToVerify = toVerifyList.stream().filter(param -> param.getName().equals(paramSource.getName().getValue())).findFirst();
            Assertions.assertThat(parameterToVerify).isPresent();
            InstanceFactoriesTestCommon.commonVerifyKiePMMLParameterField(parameterToVerify.get(), paramSource);
        });
    }

    static void commonVerifyKiePMMLDerivedField(KiePMMLDerivedField toVerify, DerivedField source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getName().getValue());
        DATA_TYPE expectedDataType = DATA_TYPE.byName((String)source.getDataType().value());
        Assertions.assertThat((Comparable)toVerify.getDataType()).isEqualTo((Object)expectedDataType);
        OP_TYPE expectedOpType = OP_TYPE.byName((String)source.getOpType().value());
        Assertions.assertThat((Comparable)toVerify.getOpType()).isEqualTo((Object)expectedOpType);
        String expectedDisplayName = "Display-" + source.getName().getValue();
        Assertions.assertThat((String)toVerify.getDisplayName()).isEqualTo(expectedDisplayName);
        InstanceFactoriesTestCommon.commonVerifyKiePMMLExpression(toVerify.getKiePMMLExpression(), source.getExpression());
    }

    static void commonVerifyKiePMMLParameterField(KiePMMLParameterField toVerify, ParameterField source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getName().getValue());
        DATA_TYPE expectedDataType = DATA_TYPE.byName((String)source.getDataType().value());
        Assertions.assertThat((Comparable)toVerify.getDataType()).isEqualTo((Object)expectedDataType);
        OP_TYPE expectedOpType = OP_TYPE.byName((String)source.getOpType().value());
        Assertions.assertThat((Comparable)toVerify.getOpType()).isEqualTo((Object)expectedOpType);
        String expectedDisplayName = "Display-" + source.getName().getValue();
        Assertions.assertThat((String)toVerify.getDisplayName()).isEqualTo(expectedDisplayName);
    }

    static void commonVerifyKiePMMLPredicate(KiePMMLPredicate toVerify, Predicate source) {
        switch (source.getClass().getSimpleName()) {
            case "CompoundPredicate": {
                InstanceFactoriesTestCommon.commonVerifyKKiePMMLCompoundPredicate((KiePMMLCompoundPredicate)toVerify, (CompoundPredicate)source);
                break;
            }
            case "False": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLFalsePredicate((KiePMMLFalsePredicate)toVerify, (False)source);
                break;
            }
            case "SimplePredicate": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLSimplePredicate((KiePMMLSimplePredicate)toVerify, (SimplePredicate)source);
                break;
            }
            case "SimpleSetPredicate": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLSimpleSetPredicate((KiePMMLSimpleSetPredicate)toVerify, (SimpleSetPredicate)source);
                break;
            }
            case "True": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLTruePredicate((KiePMMLTruePredicate)toVerify, (True)source);
                break;
            }
            default: {
                Assertions.fail((String)String.format("Predicate %s not managed", source.getClass()));
            }
        }
    }

    static void commonVerifyKKiePMMLCompoundPredicate(KiePMMLCompoundPredicate toVerify, CompoundPredicate source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getBooleanOperator().getName()).isEqualTo(source.getBooleanOperator().value());
        Assertions.assertThat((List)toVerify.getKiePMMLPredicates()).hasSameSizeAs((Iterable)source.getPredicates());
        IntStream.range(0, source.getPredicates().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLPredicate((KiePMMLPredicate)toVerify.getKiePMMLPredicates().get(i), (Predicate)source.getPredicates().get(i)));
    }

    static void commonVerifyKiePMMLFalsePredicate(KiePMMLFalsePredicate toVerify, False source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
    }

    static void commonVerifyKiePMMLSimplePredicate(KiePMMLSimplePredicate toVerify, SimplePredicate source, DataField dataField) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Object value = DATA_TYPE.byName((String)dataField.getDataType().value()).getActualValue(source.getValue());
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getField().getValue());
        Assertions.assertThat((Object)toVerify.getValue()).isEqualTo(value);
        Assertions.assertThat((String)toVerify.getOperator().getName()).isEqualTo(source.getOperator().value());
    }

    static void commonVerifyKiePMMLSimplePredicate(KiePMMLSimplePredicate toVerify, SimplePredicate source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getField().getValue());
        Assertions.assertThat((String)toVerify.getOperator().getName()).isEqualTo(source.getOperator().value());
    }

    static void commonVerifyKiePMMLSimpleSetPredicate(KiePMMLSimpleSetPredicate toVerify, SimpleSetPredicate source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getField().getValue());
        Array array = source.getArray();
        Assertions.assertThat((String)toVerify.getArrayType().getName()).isEqualTo(array.getType().value());
        Assertions.assertThat((String)toVerify.getInNotIn().getName()).isEqualTo(source.getBooleanOperator().value());
        Assertions.assertThat((List)toVerify.getValues()).hasSize(array.getN().intValue());
        String stringValue = (String)array.getValue();
        String[] valuesArray = stringValue.split(" ");
        IntStream.range(0, array.getN()).forEach(i -> {
            switch (array.getType()) {
                case INT: {
                    Assertions.assertThat(toVerify.getValues().get(i)).isEqualTo((Object)Integer.valueOf(valuesArray[i]));
                    break;
                }
                case STRING: {
                    Assertions.assertThat(toVerify.getValues().get(i)).isEqualTo((Object)valuesArray[i]);
                    break;
                }
                case REAL: {
                    Assertions.assertThat(toVerify.getValues().get(i)).isEqualTo((Object)Double.valueOf(valuesArray[i]));
                    break;
                }
                default: {
                    throw new KiePMMLException("Unknown Array " + array.getType());
                }
            }
        });
    }

    static void commonVerifyKiePMMLTruePredicate(KiePMMLTruePredicate toVerify, True source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
    }

    static void commonVerifyKiePMMLExpression(KiePMMLExpression toVerify, Expression source) {
        switch (source.getClass().getSimpleName()) {
            case "Apply": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLApply((KiePMMLApply)toVerify, (Apply)source);
                break;
            }
            case "Constant": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLConstant((KiePMMLConstant)toVerify, (Constant)source);
                break;
            }
            case "Discretize": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLDiscretize((KiePMMLDiscretize)toVerify, (Discretize)source);
                break;
            }
            case "FieldRef": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLFieldRef((KiePMMLFieldRef)toVerify, (FieldRef)source);
                break;
            }
            case "MapValues": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLMapValues((KiePMMLMapValues)toVerify, (MapValues)source);
                break;
            }
            case "NormContinuous": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLNormContinuous((KiePMMLNormContinuous)toVerify, (NormContinuous)source);
                break;
            }
            case "NormDiscrete": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLNormDiscrete((KiePMMLNormDiscrete)toVerify, (NormDiscrete)source);
                break;
            }
            case "TextIndex": {
                InstanceFactoriesTestCommon.commonVerifyKiePMMLTextIndex((KiePMMLTextIndex)toVerify, (TextIndex)source);
                break;
            }
            default: {
                Assertions.fail((String)String.format("Expression %s not managed", source.getClass()));
            }
        }
    }

    static void commonVerifyKiePMMLApply(KiePMMLApply toVerify, Apply source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getFunction()).isEqualTo(source.getFunction());
        Assertions.assertThat((Object)toVerify.getMapMissingTo()).isEqualTo((Object)source.getMapMissingTo());
        Assertions.assertThat((Object)toVerify.getDefaultValue()).isEqualTo((Object)source.getDefaultValue());
        Assertions.assertThat((String)toVerify.getInvalidValueTreatmentMethod().getName()).isEqualTo(source.getInvalidValueTreatment().value());
        List kiePMMLExpressionList = toVerify.getKiePMMLExpressions();
        Assertions.assertThat((List)kiePMMLExpressionList).hasSameSizeAs((Iterable)source.getExpressions());
        IntStream.range(0, source.getExpressions().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLExpression((KiePMMLExpression)kiePMMLExpressionList.get(i), (Expression)source.getExpressions().get(i)));
    }

    static void commonVerifyKiePMMLConstant(KiePMMLConstant toVerify, Constant source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((Object)toVerify.getValue()).isEqualTo(source.getValue());
    }

    static void commonVerifyKiePMMLDiscretize(KiePMMLDiscretize toVerify, Discretize source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getField().getValue());
        Assertions.assertThat((String)toVerify.getMapMissingTo()).isEqualTo(source.getMapMissingTo());
        Assertions.assertThat((String)toVerify.getDefaultValue()).isEqualTo(source.getDefaultValue());
        Assertions.assertThat((String)toVerify.getDataType().getName()).isEqualTo(source.getDataType().value());
        Assertions.assertThat((List)toVerify.getDiscretizeBins()).hasSameSizeAs((Iterable)source.getDiscretizeBins());
        IntStream.range(0, source.getDiscretizeBins().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLDiscretizeBin((KiePMMLDiscretizeBin)toVerify.getDiscretizeBins().get(i), (DiscretizeBin)source.getDiscretizeBins().get(i)));
    }

    static void commonVerifyKiePMMLFieldRef(KiePMMLFieldRef toVerify, FieldRef source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getField().getValue());
        Assertions.assertThat((Object)toVerify.getMapMissingTo()).isEqualTo((Object)source.getMapMissingTo());
    }

    static void commonVerifyKiePMMLMapValues(KiePMMLMapValues toVerify, MapValues source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getOutputColumn()).isEqualTo(source.getOutputColumn());
        Assertions.assertThat((String)toVerify.getMapMissingTo()).isEqualTo(source.getMapMissingTo());
        Assertions.assertThat((String)toVerify.getDefaultValue()).isEqualTo(source.getDefaultValue().toString());
        Assertions.assertThat((String)toVerify.getDataType().getName()).isEqualTo(source.getDataType().value());
        InstanceFactoriesTestCommon.commonVerifyKiePMMLInlineTableWithCells(toVerify.getInlineTable(), source.getInlineTable());
        Assertions.assertThat((List)toVerify.getFieldColumnPairs()).hasSameSizeAs((Iterable)source.getFieldColumnPairs());
        IntStream.range(0, source.getFieldColumnPairs().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLFieldColumnPair((KiePMMLFieldColumnPair)toVerify.getFieldColumnPairs().get(i), (FieldColumnPair)source.getFieldColumnPairs().get(i)));
    }

    static void commonVerifyKiePMMLNormContinuous(KiePMMLNormContinuous toVerify, NormContinuous source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getOutlierTreatmentMethod().getName()).isEqualTo(source.getOutliers().value());
        Assertions.assertThat((Object)toVerify.getMapMissingTo()).isEqualTo((Object)source.getMapMissingTo());
        List toConvertLinearNorms = source.getLinearNorms();
        InstanceFactoriesTestCommon.sortLinearNorms(toConvertLinearNorms);
        List retrievedLinearNorms = toVerify.getLinearNorms();
        Assertions.assertThat((List)retrievedLinearNorms).hasSameSizeAs((Iterable)toConvertLinearNorms);
        IntStream.range(0, toConvertLinearNorms.size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLLinearNorm((KiePMMLLinearNorm)retrievedLinearNorms.get(i), (LinearNorm)toConvertLinearNorms.get(i)));
    }

    static void commonVerifyKiePMMLNormDiscrete(KiePMMLNormDiscrete toVerify, NormDiscrete source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getField().getValue());
        Assertions.assertThat((Object)toVerify.getMapMissingTo()).isEqualTo((Object)source.getMapMissingTo());
        Assertions.assertThat((String)toVerify.getValue()).isEqualTo(source.getValue().toString());
    }

    static void commonVerifyKiePMMLTextIndex(KiePMMLTextIndex toVerify, TextIndex source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getLocalTermWeights().getName()).isEqualTo(source.getLocalTermWeights().value());
        Assertions.assertThat((String)toVerify.getCountHits().getName()).isEqualTo(source.getCountHits().value());
        Assertions.assertThat((String)toVerify.getWordSeparatorCharacterRE()).isEqualTo(StringEscapeUtils.escapeJava((String)source.getWordSeparatorCharacterRE()));
        InstanceFactoriesTestCommon.commonVerifyKiePMMLExpression(toVerify.getExpression(), source.getExpression());
        Assertions.assertThat((List)toVerify.getTextIndexNormalizations()).hasSameSizeAs((Iterable)source.getTextIndexNormalizations());
        IntStream.range(0, source.getTextIndexNormalizations().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLTextIndexNormalization((KiePMMLTextIndexNormalization)toVerify.getTextIndexNormalizations().get(i), (TextIndexNormalization)source.getTextIndexNormalizations().get(i)));
        Assertions.assertThat((boolean)toVerify.isCaseSensitive()).isEqualTo(source.isCaseSensitive());
        Assertions.assertThat((int)toVerify.getMaxLevenshteinDistance()).isEqualTo(source.getMaxLevenshteinDistance().intValue());
        Assertions.assertThat((boolean)toVerify.isTokenize()).isEqualTo(source.isTokenize());
    }

    static void commonVerifyKiePMMLTextIndexNormalization(KiePMMLTextIndexNormalization toVerify, TextIndexNormalization source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
    }

    static void commonVerifyKiePMMLDiscretizeBin(KiePMMLDiscretizeBin toVerify, DiscretizeBin source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        InstanceFactoriesTestCommon.commonVerifyKiePMMLInterval(toVerify.getInterval(), source.getInterval());
        Assertions.assertThat((String)toVerify.getBinValue()).isEqualTo(source.getBinValue());
    }

    static void commonVerifyKiePMMLFieldColumnPair(KiePMMLFieldColumnPair toVerify, FieldColumnPair source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getField().getValue());
        Assertions.assertThat((String)toVerify.getColumn()).isEqualTo(source.getColumn());
    }

    static void commonVerifyKiePMMLInlineTableWithCells(KiePMMLInlineTable toVerify, InlineTable source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((List)toVerify.getRows()).hasSameSizeAs((Iterable)source.getRows());
        IntStream.range(0, source.getRows().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLRowWithCells((KiePMMLRow)toVerify.getRows().get(i), (Row)source.getRows().get(i)));
    }

    static void commonVerifyKiePMMLInterval(KiePMMLInterval toVerify, Interval source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((Object)toVerify.getLeftMargin()).isEqualTo((Object)source.getLeftMargin());
        Assertions.assertThat((Object)toVerify.getRightMargin()).isEqualTo((Object)source.getRightMargin());
        Assertions.assertThat((String)toVerify.getClosure().getName()).isEqualTo(source.getClosure().value());
    }

    static void commonVerifyKiePMMLMiningField(KiePMMLMiningField toVerify, MiningField source, DataField dataField) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getName().getValue());
        Assertions.assertThat((String)toVerify.getOpType().getName()).isEqualTo(source.getOpType().value());
        Assertions.assertThat((String)toVerify.getFieldUsageType().getName()).isEqualTo(source.getUsageType().value());
        Assertions.assertThat((String)toVerify.getInvalidValueTreatmentMethod().getName()).isEqualTo(source.getInvalidValueTreatment().value());
        Assertions.assertThat((String)toVerify.getMissingValueTreatmentMethod().getName()).isEqualTo(source.getMissingValueTreatment().value());
        Assertions.assertThat((String)toVerify.getInvalidValueReplacement()).isEqualTo(source.getInvalidValueReplacement());
        Assertions.assertThat((String)toVerify.getMissingValueReplacement()).isEqualTo(source.getMissingValueReplacement());
        Assertions.assertThat((String)toVerify.getDataType().getName()).isEqualTo(dataField.getDataType().value());
        Assertions.assertThat((List)toVerify.getIntervals()).hasSameSizeAs((Iterable)dataField.getIntervals());
        IntStream.range(0, dataField.getIntervals().size()).forEach(i -> InstanceFactoriesTestCommon.commonVerifyKiePMMLInterval((KiePMMLInterval)toVerify.getIntervals().get(i), (Interval)dataField.getIntervals().get(i)));
    }

    static void commonVerifyKiePMMLOutputField(KiePMMLOutputField toVerify, OutputField source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(source.getName().getValue());
        Assertions.assertThat((Object)toVerify.getValue()).isEqualTo(source.getValue());
        Assertions.assertThat((String)toVerify.getDataType().getName()).isEqualTo(source.getDataType().value());
        Assertions.assertThat((String)((String)toVerify.getTargetField().get())).isEqualTo(source.getTargetField().getValue());
        Assertions.assertThat((String)toVerify.getResultFeature().getName()).isEqualTo(source.getResultFeature().value());
        Assertions.assertThat((Integer)toVerify.getRank()).isEqualTo((Object)source.getRank());
        Assertions.assertThat((Object)toVerify.getValue()).isEqualTo(source.getValue());
        InstanceFactoriesTestCommon.commonVerifyKiePMMLExpression(toVerify.getKiePMMLExpression(), source.getExpression());
    }

    static void commonVerifyKiePMMLTarget(KiePMMLTarget toVerify, Target source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((List)source.getTargetValues()).hasSameSizeAs((Iterable)toVerify.getTargetValues());
        OP_TYPE expectedOpType = OP_TYPE.byName((String)source.getOpType().value());
        Assertions.assertThat((Comparable)toVerify.getOpType()).isEqualTo((Object)expectedOpType);
        Assertions.assertThat((String)toVerify.getField()).isEqualTo(source.getField().getValue());
        CAST_INTEGER expectedCastInteger = CAST_INTEGER.byName((String)source.getCastInteger().value());
        Assertions.assertThat((Comparable)toVerify.getCastInteger()).isEqualTo((Object)expectedCastInteger);
        Assertions.assertThat((Double)toVerify.getMin()).isCloseTo(source.getMin().doubleValue(), Offset.offset((Number)0.0));
        Assertions.assertThat((Double)toVerify.getMax()).isCloseTo(source.getMax().doubleValue(), Offset.offset((Number)0.0));
        Assertions.assertThat((double)toVerify.getRescaleConstant()).isCloseTo(source.getRescaleConstant().doubleValue(), Offset.offset((Number)0.0));
        Assertions.assertThat((double)toVerify.getRescaleFactor()).isCloseTo(source.getRescaleFactor().doubleValue(), Offset.offset((Number)0.0));
    }

    static void commonVerifyKiePMMLRow(KiePMMLRow toVerify, Row source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((Map)toVerify.getColumnValues()).isEmpty();
    }

    static void commonVerifyKiePMMLRowWithCells(KiePMMLRow toVerify, Row source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((Map)toVerify.getColumnValues()).hasSize(2);
    }

    static void commonVerifyKiePMMLTargetValue(KiePMMLTargetValue toVerify, TargetValue source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((String)toVerify.getValue()).isEqualTo(source.getValue().toString());
        Assertions.assertThat((String)toVerify.getDisplayValue()).isEqualTo(source.getDisplayValue());
        Assertions.assertThat((Double)toVerify.getPriorProbability()).isCloseTo(source.getPriorProbability().doubleValue(), Offset.offset((Number)0.0));
        Assertions.assertThat((Double)toVerify.getDefaultValue()).isCloseTo(source.getDefaultValue().doubleValue(), Offset.offset((Number)0.0));
    }

    static void commonVerifyKiePMMLLinearNorm(KiePMMLLinearNorm toVerify, LinearNorm source) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((double)toVerify.getOrig()).isCloseTo(source.getOrig().doubleValue(), Offset.offset((Number)0.0));
        Assertions.assertThat((double)toVerify.getNorm()).isCloseTo(source.getNorm().doubleValue(), Offset.offset((Number)0.0));
    }

    static void sortLinearNorms(List<LinearNorm> toSort) {
        toSort.sort((o1, o2) -> (int)(o1.getOrig().doubleValue() - o2.getOrig().doubleValue()));
    }
}

