/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.compiler.executor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.clustering.ClusteringModel;
import org.junit.Test;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLModelWithSources;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.testutils.TestUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.models.clustering.compiler.executor.ClusteringModelImplementationProvider;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringModel;

public class ClusteringModelImplementationProviderTest {
    private static final String SOURCE_FILE = "SingleIrisKMeansClustering.pmml";
    private static final ClusteringModelImplementationProvider PROVIDER = new ClusteringModelImplementationProvider();

    private static ClusteringModel getModel(PMML pmml) {
        Assertions.assertThat((Object)pmml).isNotNull();
        Assertions.assertThat((List)pmml.getModels()).hasSize(1);
        Model model = (Model)pmml.getModels().get(0);
        Assertions.assertThat((Object)model).isInstanceOf(ClusteringModel.class);
        return (ClusteringModel)model;
    }

    @Test
    public void getPMMLModelType() {
        Assertions.assertThat((Comparable)PROVIDER.getPMMLModelType()).isEqualTo((Object)PMML_MODEL.CLUSTERING_MODEL);
    }

    @Test
    public void getKiePMMLModel() throws Exception {
        PMML pmml = TestUtils.loadFromFile((String)SOURCE_FILE);
        ClusteringModel model = ClusteringModelImplementationProviderTest.getModel(pmml);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLClusteringModel retrieved = PROVIDER.getKiePMMLModel((CompilationDTO)compilationDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isInstanceOf(Serializable.class);
    }

    @Test
    public void getKiePMMLModelWithSources() throws Exception {
        PMML pmml = TestUtils.loadFromFile((String)SOURCE_FILE);
        ClusteringModel model = ClusteringModelImplementationProviderTest.getModel(pmml);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLModelWithSources retrieved = PROVIDER.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Map sourcesMap = retrieved.getSourcesMap();
        Assertions.assertThat((Map)sourcesMap).isNotNull();
        Assertions.assertThat((Map)sourcesMap).isNotEmpty();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Map compiled = KieMemoryCompiler.compile((Map)sourcesMap, (ClassLoader)classLoader);
        for (Class clazz : compiled.values()) {
            Assertions.assertThat((Class)clazz).isInstanceOf(Serializable.class);
        }
    }
}

