/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.model;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KiePMMLCluster {
    private final List<Double> values;
    private final Optional<String> id;
    private final Optional<String> name;

    public KiePMMLCluster(String id, String name, Double ... values) {
        this.values = Collections.unmodifiableList(Stream.of(values).collect(Collectors.toList()));
        this.id = Optional.ofNullable(id);
        this.name = Optional.ofNullable(name);
    }

    public List<Double> getValues() {
        return this.values;
    }

    public double[] getValuesArray() {
        return this.values.stream().mapToDouble(Double::doubleValue).toArray();
    }

    public Optional<String> getId() {
        return this.id;
    }

    public Optional<String> getName() {
        return this.name;
    }
}

