/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.clustering.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class ClusterWithTransformationsTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "ClusterWithTransformations.pmml";
    private static final String MODEL_NAME = "ClusterWithTransformations";
    private static final String TARGET_FIELD = "class";
    private static final String OUT_NORMCONTINUOUS_FIELD = "out_normcontinuous_field";
    private static final String OUT_NORMDISCRETE_FIELD = "out_normdiscrete_field";
    private static final String OUT_DISCRETIZE_FIELD = "out_discretize_field";
    private static final String OUT_MAPVALUED_FIELD = "out_mapvalued_field";
    private static final String OUT_TEXT_INDEX_NORMALIZATION_FIELD = "out_text_index_normalization_field";
    private static final String TEXT_INPUT = "Testing the app for a few days convinced me the interfaces are excellent!";
    private static PMMLRuntime pmmlRuntime;
    private final double sepalLength;
    private final double sepalWidth;
    private final double petalLength;
    private final double petalWidth;
    private final String irisClass;
    private final double outNormcontinuousField;

    public ClusterWithTransformationsTest(double sepalLength, double sepalWidth, double petalLength, double petalWidth, String irisClass, double outNormcontinuousField) {
        this.sepalLength = sepalLength;
        this.sepalWidth = sepalWidth;
        this.petalLength = petalLength;
        this.petalWidth = petalWidth;
        this.irisClass = irisClass;
        this.outNormcontinuousField = outNormcontinuousField;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = ClusterWithTransformationsTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({4.4, 3.0, 1.3, 0.2, "3", 4.966666666666667}, {5.0, 3.3, 1.4, 0.2, "3", 5.433333333333334}, {7.0, 3.2, 4.7, 1.4, "2", 6.950000000000001}, {5.7, 2.8, 4.1, 1.3, "4", 5.937500000000001}, {6.3, 3.3, 6.0, 2.5, "1", 6.1625}, {6.7, 3.0, 5.2, 2.3, "1", 6.575});
    }

    @Test
    public void testClusterWithTransformations() throws Exception {
        String expected;
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("sepal_length", this.sepalLength);
        inputData.put("sepal_width", this.sepalWidth);
        inputData.put("petal_length", this.petalLength);
        inputData.put("petal_width", this.petalWidth);
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", 34.1);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.irisClass);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMCONTINUOUS_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMCONTINUOUS_FIELD)).isEqualTo((Object)this.outNormcontinuousField);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isNotNull();
        if (this.irisClass.equals("1")) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isEqualTo((Object)1.0);
        } else {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isEqualTo((Object)0.0);
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isNotNull();
        if (this.sepalLength > 4.7 && this.sepalLength < 5.2) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"abc");
        } else if (this.sepalLength >= 5.6 && this.sepalLength < 5.9) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"def");
        } else {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"defaultValue");
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_MAPVALUED_FIELD)).isNotNull();
        switch (this.irisClass) {
            case "1": 
            case "C_ONE": {
                expected = "virginica";
                break;
            }
            case "2": 
            case "C_TWO": {
                expected = "versicolor";
                break;
            }
            case "3": 
            case "C_THREE": {
                expected = "setosa";
                break;
            }
            case "4": 
            case "C_FOUR": {
                expected = "unknown";
                break;
            }
            default: {
                throw new Exception("Unexpected irisClass " + this.irisClass);
            }
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_MAPVALUED_FIELD)).isEqualTo((Object)expected);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_TEXT_INDEX_NORMALIZATION_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_TEXT_INDEX_NORMALIZATION_FIELD)).isEqualTo((Object)1.0);
    }

    @Test(expected=KiePMMLException.class)
    public void testClusterWithTransformationsWithoutRequired() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("sepal_length", this.sepalLength);
        inputData.put("sepal_width", this.sepalWidth);
        inputData.put("petal_length", this.petalLength);
        inputData.put("petal_width", this.petalWidth);
        inputData.put("text_input", TEXT_INPUT);
        this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
    }

    @Test
    public void testClusterWithTransformationsConvertible() {
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("sepal_length", String.valueOf(this.sepalLength));
        inputData.put("sepal_width", String.valueOf(this.sepalWidth));
        inputData.put("petal_length", String.valueOf(this.petalLength));
        inputData.put("petal_width", String.valueOf(this.petalWidth));
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", "34.1");
        Assert.assertNotNull((Object)this.evaluate(pmmlRuntime, inputData, MODEL_NAME));
    }

    @Test(expected=KiePMMLException.class)
    public void testClusterWithTransformationsNotConvertible() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("sepal_length", this.sepalLength);
        inputData.put("sepal_width", this.sepalWidth);
        inputData.put("petal_length", this.petalLength);
        inputData.put("petal_width", this.petalWidth);
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", true);
        this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
    }

    @Test(expected=KiePMMLException.class)
    public void testClusterWithTransformationsInvalidValue() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("sepal_length", this.sepalLength);
        inputData.put("sepal_width", this.sepalWidth);
        inputData.put("petal_length", this.petalLength);
        inputData.put("petal_width", this.petalWidth);
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", 4.1);
        this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
    }
}

