/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.clustering.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.data.Percentage;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class MultipleClustersSameClassTest
extends AbstractPMMLTest {
    private static final double DOUBLE_VALID_PERCENTAGE = 0.99999;
    private static final String FILE_NAME = "multipleClustersSameClass.pmml";
    private static final String MODEL_NAME = "multipleClusterSameClassModel";
    private static final String AFFINITY_FIELD = "predictedAffinity";
    private static final String CLUSTER_AFFINITY_FIELD = "predictedClusterAffinity";
    private static final String CLUSTER_ID_FIELD = "predictedValue";
    private static final String CLUSTER_NAME_FIELD = "predictedDisplayValue";
    protected static PMMLRuntime pmmlRuntime;
    private double dimension1;
    private double dimension2;
    private String classId;
    private String className;
    private double affinity;

    public MultipleClustersSameClassTest(double dimension1, double dimension2, String classId, String className, double affinity) {
        this.dimension1 = dimension1;
        this.dimension2 = dimension2;
        this.classId = classId;
        this.className = className;
        this.affinity = affinity;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = MultipleClustersSameClassTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0.0, 0.0, "1", "classA", 0.0}, {0.5, 0.0, "1", "classA", 0.25}, {1.0, 1.0, "2", "classB", 0.0}, {1.0, 3.0, "2", "classB", 4.0}, {-1, -1, "3", "classA", 0.0}, {-1.3, -1.4, "3", "classA", 0.25}, {5.0, 5.0, "4", "classB", 0.0}, {8.0, 9.0, "4", "classB", 25.0}, {-3.0, 5.0, "5", "classC", 0.0}, {-2.0, 5.0, "5", "classC", 1.0});
    }

    @Test
    public void test() {
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("Dimension1", this.dimension1);
        inputData.put("Dimension2", this.dimension2);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(CLUSTER_ID_FIELD)).isEqualTo((Object)this.classId);
        Assertions.assertThat(pmml4Result.getResultVariables().get(CLUSTER_NAME_FIELD)).isEqualTo((Object)this.className);
        MultipleClustersSameClassTest.assertDoubleVariable(pmml4Result, AFFINITY_FIELD, this.affinity);
        MultipleClustersSameClassTest.assertDoubleVariable(pmml4Result, CLUSTER_AFFINITY_FIELD, this.affinity);
    }

    private static void assertDoubleVariable(PMML4Result pmml4Result, String variableName, double expectedValue) {
        ((AbstractDoubleAssert)Assertions.assertThat(pmml4Result.getResultVariables().get(variableName)).asInstanceOf(InstanceOfAssertFactories.DOUBLE)).isCloseTo(expectedValue, Percentage.withPercentage((double)0.99999));
    }
}

